<?PHP
#
#   FILE:  AddResourceComment.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_POSTCOMMENTS))
{
    return;
}

# get resource using resource Id
$ResourceId = GetFormValue("RI", GetFormValue("ResourceId"));

if (is_null($ResourceId))
{
    $H_ErrorMessages[]= "No ResourceId Specified";
}
elseif (!Resource::ItemExists($ResourceId))
{
    $H_ErrorMessages[]= "Invalid resource ID specified.";
}
else
{
    $H_Resource = new Resource(intval($ResourceId));
    $Schema = $H_Resource->Schema();
}

# get message using messsage Id
$H_MessageId = GetFormValue("MI", GetFormValue("MessageId"));

if (!is_null($H_MessageId))
{
    $H_MessageId = intval($H_MessageId);
    if (!Message::ItemExists($H_MessageId))
    {
        $H_ErrorMessages[]= "Invalid message requested";
    }
    else
    {
        $Message = new Message( $H_MessageId );
        if ($GLOBALS["G_User"]->Id() == $Message->PosterId() ||
            $GLOBALS["G_User"]->HasPriv(PRIV_SYSADMIN) )
        {
            $H_Body = $Message->Body();
        }
        else
        {
            $H_ErrorMessages[]= "You don't have permissions to edit that message";
        }
    }
}
else
{
    if (isset($_SESSION["Body"]))
    {
        $H_Body = $_SESSION["Body"];
        unset ($_SESSION["Body"]);
    }
    else
    {
        $H_Body = "";
    }
}

# If there were errors, bail:
if (isset($H_ErrorMessages))
{
    return;
}

$TitleField = $Schema->GetFieldByMappedName("Title");

if ($H_Resource->UserCanViewField($GLOBALS["G_User"], $TitleField))
{
    $H_Title = $H_Resource->Get($TitleField);
}

if (isset($H_MessageId))
{
    PageTitle("Update Resource Comment");
}
else
{
    PageTitle("Add Resource Comment");
}
