<?PHP
#
#   FILE:  ConfirmMailIt.php (MailIt plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015-2016 Edward Almasy and Internet Scout Research Gruop
#   http://scout.wisc.edu/cwis
#

# ----- MAIN -----------------------------------------------------------------

$ResourceId = GetFormValue("ID");

# make sure the resource ID is valid
if (!Resource::ItemExists($ResourceId))
{
    # if not, go back to the full record page
    $GLOBALS["AF"]->SetJumpToPage("index.php?P=FullRecord&ID=" . $ResourceId);
    return;
}

# get the resource
$H_Resource = new Resource($ResourceId);

# get a copy of the MailIt plugin
$Plugin = $GLOBALS["G_PluginManager"]->GetPlugin("MailIt");

# get the header and body config settings
$H_HeaderText = $Plugin->ConfigSetting("HeaderText");
$H_BodyText = $Plugin->ConfigSetting("BodyText");

$Errors = "";
if (array_key_exists("ER", $_GET))
{
    $ErrorNumber = $_GET["ER"];
    switch($ErrorNumber)
    {
        case 3;
            $Errors = "<br>The email you are attempting to reach is not valid.</br>";
            break;
    }
}
