<?PHP
#
#   FILE:  DownloadFile.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$FileId = GetFormValue("ID", GetFormValue("Id"));

# if file ID was supplied and is valid
if (!is_null($FileId) && File::ItemExists($FileId))
{
    # load file
    $File = new File($FileId);

    # check whether user can view file
    if ($File->ResourceId() != Resource::NO_ITEM)
    {
        $Resource = new Resource($File->ResourceId());
        if ($File->FieldId() != Item::NO_ITEM)
        {
            $Field = new MetadataField($File->FieldId());
            $CanView = $Resource->UserCanViewField($GLOBALS["G_User"], $Field);
        }
        else
        {
            $CanView = $Resource->UserCanView($GLOBALS["G_User"]);
        }
    }
    else
    {
        $CanView = TRUE;
    }

    # if user can view file
    if ($CanView)
    {
        # download file
        $GLOBALS["AF"]->DownloadFile($File->GetNameOfStoredFile(),
                $File->Name(), $File->GetMimeType());
    }
    else
    {
        # print message about unauthorized access
        CheckAuthorization(-1);
    }
}

# if a file was not found, the HTML template will be loaded instead
