<?PHP
#
#   FILE:  MDHome.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Metadata Tool");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

// @codingStandardsIgnoreStart

function PrintTotalNumberOfResources()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalNumberOfResources"]));
}

function PrintNumberOfReleasedResources()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["NumberOfReleasedResources"]));
}

function PrintNumberOfRatedResources()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["NumberOfRatedResources"]));
}

function PrintTotalNumberOfClassifications()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalNumberOfClassifications"]));
}

function PrintTotalNumberOfControlledNames()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalNumberOfControlledNames"]));
}

function PrintTotalSearchTerms()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalSearchTerms"]));
}

// @codingStandardsIgnoreEnd

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_CLASSADMIN, PRIV_NAMEADMIN,
                        PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN))
{
    return;
}

global $G_CollectionStats, $G_StatsUpdateTime;

$DB = new Database();

if (isset($_GET["US"]))
{
    global $AF;
    $AF->LoadFunction("UpdateCollectionStats");
    UpdateCollectionStats();
    $AF->SetJumpToPage("MDHome");
}
else
{
    $G_StatsUpdateTime = $DB->Query(
        "SELECT Updated FROM CachedValues WHERE Name='CollectionStats'",
        "Updated");

    if (time() - strtotime($G_StatsUpdateTime) > 3600) {
        global $AF;
        $AF->QueueTask("UpdateCollectionStats");
    }

    $G_CollectionStats = unserialize(
        $DB->Query(
            "SELECT Value FROM CachedValues WHERE Name='CollectionStats'",
            "Value"));

    # generate collection stats if they don't exist yet
    if ($G_CollectionStats === FALSE)
    {
        $AF->SetJumpToPage("MDHome&US");
    }
}


# retrieve lists of recently modified and recently added resources to display
$RFactory = new ResourceFactory(MetadataSchema::SCHEMAID_DEFAULT);

$AllRecentlyAdded = $RFactory->GetResourceIdsSortedBy("Date Of Record Creation", FALSE);
$H_RecentlyAdded = [];
foreach ($AllRecentlyAdded as $Id)
{
    if ($Id >= 0)
    {
        $H_RecentlyAdded[$Id]= new Resource($Id);
        if (count($H_RecentlyAdded) > 10)
        {
            break;
        }
    }
}

# retrieve list of recently modified resources that aren't also new resources
$AllRecentlyModified = $RFactory->GetResourceIdsSortedBy("Date Last Modified", FALSE);
$H_RecentlyModified = [];
foreach ($AllRecentlyModified as $Id)
{
    if ($Id >= 0)
    {
        $Resource = new Resource($Id);
        if (in_array($Id, $H_RecentlyAdded))
        {
            if (strtotime($Resource->Get("Date Last Modified"))
                <= strtotime($Resource->Get("Date Of Record Creation")))
            {
                continue;
            }
        }

        $H_RecentlyModified[$Id] = $Resource;

        if (count($H_RecentlyModified) > 10)
        {
            break;
        }
    }
}