<?PHP
#
#   FILE:  EditPasswordMail.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- CONFIGURATION  -------------------------------------------------------

PageTitle("Edit Password E-Mail Text");
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }


# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)


# ----- MAIN -----------------------------------------------------------------

# clear error flags
$H_ErrorWithResetBody = FALSE;
$H_ErrorWithActivationBody = FALSE;
$H_ErrorWithChangeBody = FALSE;
$H_EditingComplete = FALSE;

# if we have values from a submitted form
if (isset($_POST["Submit"]))
{
    # if user requested to cancel editing
    if ($_POST["Submit"] == "Cancel")
    {
        # return to administration menu
        $AF->SetJumpToPage("SysAdmin");
        return;
    }
    else
    {
        # retrieve values from form
        $H_ActivationSubject = @$_POST["F_ActivationSubject"];
        $H_ActivationBody = @$_POST["F_ActivationBody"];
        $H_ResetSubject = @$_POST["F_ResetSubject"];
        $H_ResetBody = @$_POST["F_ResetBody"];
        $H_ChangeSubject = @$_POST["F_ChangeSubject"];
        $H_ChangeBody = @$_POST["F_ChangeBody"];

        # if account activation e-mail body is invalid
        if ((substr_count($H_ActivationBody, "X-ACTIVATIONURL-X") == 0)
                && (substr_count($H_ActivationBody, "X-ACTIVATIONPARAMETERS-X") == 0)
                && ((substr_count($H_ActivationBody, "X-MANUALACTIVATIONURL-X") == 0)
                    || (substr_count($H_ActivationBody, "X-USERNAME-X") == 0)
                    || (substr_count($H_ActivationBody, "X-ACTIVATIONCODE-X") == 0)))
        {
            # set error flag
            $H_ErrorWithActivationBody = TRUE;
        }

        # if password reset e-mail body is invalid
        if ((substr_count($H_ResetBody, "X-RESETURL-X") == 0)
                && (substr_count($H_ResetBody, "X-RESETPARAMETERS-X") == 0)
                && ((substr_count($H_ResetBody, "X-MANUALRESETURL-X") == 0)
                    || (substr_count($H_ResetBody, "X-USERNAME-X") == 0)
                    || (substr_count($H_ResetBody, "X-RESETCODE-X") == 0)))
        {
            # set error flag
            $H_ErrorWithResetBody = TRUE;
        }

        # if mail change e-mail body is invalid
        if ((substr_count($H_ChangeBody, "X-CHANGEURL-X") == 0)
                && (substr_count($H_ChangeBody, "X-CHANGEPARAMETERS-X") == 0)
                && ((substr_count($H_ChangeBody, "X-MANUALCHANGE-X") == 0)
                    || (substr_count($H_ChangeBody, "X-USERNAME-X") == 0)
                    || (substr_count($H_ChangeBody, "X-CHANGECODE-X") == 0)))
        {
            # set error flag
            $H_ErrorWithChangeBody = TRUE;
        }

        # if submitted values are all valid
        if (($H_ErrorWithActivationBody == FALSE)
            && ($H_ErrorWithResetBody == FALSE)
            && ($H_ErrorWithChangeBody == FALSE))
        {
            # save submitted values
            $GLOBALS["G_SysConfig"]->PasswordMailSubject($H_ActivationSubject);
            $GLOBALS["G_SysConfig"]->PasswordMailBody($H_ActivationBody);
            $GLOBALS["G_SysConfig"]->PasswordResetMailSubject($H_ResetSubject);
            $GLOBALS["G_SysConfig"]->PasswordResetMailBody($H_ResetBody);
            $GLOBALS["G_SysConfig"]->MailChangeMailSubject($H_ChangeSubject);
            $GLOBALS["G_SysConfig"]->MailChangeMailBody($H_ChangeBody);


            # set flag indicating editing is complete
            $H_EditingComplete = TRUE;
        }
    }
}
else
{
    # load values from system configuration
    $H_ActivationSubject = $GLOBALS["G_SysConfig"]->PasswordMailSubject();
    $H_ActivationBody = $GLOBALS["G_SysConfig"]->PasswordMailBody();
    $H_ResetSubject = $GLOBALS["G_SysConfig"]->PasswordResetMailSubject();
    $H_ResetBody = $GLOBALS["G_SysConfig"]->PasswordResetMailBody();
    $H_ChangeSubject = $GLOBALS["G_SysConfig"]->MailChangeMailSubject();
    $H_ChangeBody = $GLOBALS["G_SysConfig"]->MailChangeMailBody();
}

?>
