<?PHP
#
#   FILE:  Entries.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$H_Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

if (isset($_GET["BlogId"]))
{
    $BlogId = intval($_GET["BlogId"]);
}
else
{
    # if the blog id is not given, just use the first available blog from the
    # list
    $BlogId = current(array_keys($H_Blog->GetAvailableBlogs()));
}

$H_Blog->SetCurrentBlog( $BlogId );

# set the page title to the blog name
PageTitle($H_Blog->BlogName());

# set up some basic values
$H_StartingIndex = GetFormValue("SI", 0);
$H_EntriesPerPage = $H_Blog->EntriesPerPage();
$H_SchemaId = $H_Blog->GetSchemaId();
$H_Entries = array();

# get the blog entries
$Schema = new MetadataSchema($H_SchemaId);
$Factory = new Blog_EntryFactory($BlogId);
$PublicationField = $Schema->GetFieldByName(Blog::PUBLICATION_DATE_FIELD_NAME);
$DBFieldName = $PublicationField->DBFieldName();
$EntryIds = $Factory->GetItemIds(
    $DBFieldName." < '".date("Y-m-d H:i:s")."'",
    FALSE,
    $DBFieldName,
    FALSE);
$H_EntryCount = count($EntryIds);

# calculate ID array checksum and reset paging if list has changed
$H_ListChecksum = md5(serialize($EntryIds));
if ($H_ListChecksum != GetFormValue("CK")) {  $H_StartingIndex = 0;  }

# prune entry IDs down to just currently-selected segment
$EntryIds = array_slice($EntryIds, $H_StartingIndex, $H_EntriesPerPage);

# load blog entries from IDs
foreach ($EntryIds as $Id)
{
    $H_Entries[$Id] = new Blog_Entry($Id);
}

# additional variables
$H_BlogName = $H_Blog->BlogName();

# tag page so it will be cleared when events are edited
$GLOBALS["AF"]->AddPageCacheTag("ResourceList".$H_SchemaId);

