<?PHP
#
#   FILE:  OAIItemFactory.php
#
#   Part of the ScoutLib application support library
#   Copyright 2009-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu
#

interface OAIItemFactory
{
    /**
    * Get an Item.
    * @param int $ItemId ItemId to fetch.
    * @return mixed Requested Items.
    */
    public function GetItem($ItemId);

    /**
    * Get a list of items, optionally restricted by creation date.
    * @param string $StartingDate Starting date for list (OPTIONAL).
    * @param string $EndingDate Ending date for list.
    * @return array Requested Items.
    */
    public function GetItems($StartingDate = NULL, $EndingDate = NULL);

    /**
    * Get array of Items in a specified OAI set (if supported).
    * @param string $SetSpec OAI set specification.
    * @param string $StartingDate Starting date (OPTIONAL).
    * @param string $EndingDate Ending date (OPTIONAL).
    * @return array Requested items.
    */
    public function GetItemsInSet($SetSpec, $StartingDate = NULL, $EndingDate = NULL);

    /**
    * Get the list of supported OAI sets.
    * @return array of supported sets.
    */
    public function GetListOfSets();

    /**
    * Retrieve IDs of items that match search paramters when OAI-SQ is supported.
    * @param mixed $SearchParams Search parameters to use.
    * @param mixed|null $StartingDate Starting date for search.
    * @param mixed|null $EndingDate Ending date for search.
    */
    public function SearchForItems(
        $SearchParams, $StartingDate = NULL, $EndingDate = NULL);
}
