<?PHP
#
#   FILE:  EditFeedComplete.php (RSSExport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

# leave if the user wasn't authorized
if (!CheckAuthorization(PRIV_SYSADMIN)) { return; }

global $AF;

# check for ID
if (!GetArrayValue($_POST, "F_ID"))
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}

# if we are cancelling, bounce back to the list feeds page
if (GetArrayValue($_POST, "F_Submit") == "Cancel")
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}

# if we are deleting, go to the confirm delete page
if (GetArrayValue($_POST, "F_Submit") == "Delete")
{
    $Id = GetArrayValue($_POST, "F_ID", -1);
    $AF->SetJumpToPage("index.php?P=P_RSSExport_ConfirmDelete&ID=" . $Id);
    return;
}

# set up error handling for HTML page
$H_ErrorMessages = new ErrorList();

# get all schemas
$AllSchemas = MetadataSchema::GetAllSchemas();

# handle form variables
$Id = GetArrayValue($_POST, "F_ID", -1);
$CleanUrl = trim(GetArrayValue($_POST, "F_CleanUrl"));
$NumItems = intval(GetArrayValue($_POST, "F_NumItems"));
$ShowResourceImages = intval(GetArrayValue($_POST, "F_ShowResourceImages"));
$NotifyBrowser = intval(GetArrayValue($_POST, "F_NotifyBrowser"));
$Title = trim(GetArrayValue($_POST, "F_Title"));
$Description = trim(GetArrayValue($_POST, "F_Description"));
$Copyright = trim(GetArrayValue($_POST, "F_Copyright"));
$ManagingEditor = trim(GetArrayValue($_POST, "F_ManagingEditor"));
$WebMaster = trim(GetArrayValue($_POST, "F_WebMaster"));
$LastBuildDate = GetArrayValue($_POST, "F_LastBuildDate");
$Category = trim(GetArrayValue($_POST, "F_Category"));
$SearchParameters = trim(GetArrayValue($_POST, "F_SearchParameters"));
$ImageUrl = trim(GetArrayValue($_POST, "F_ImageUrl"));
$ImageWidth = strlen(GetArrayValue($_POST, "F_ImageWidth")) ?
        intval(GetArrayValue($_POST, "F_ImageWidth")) : NULL;
$ImageHeight = strlen(GetArrayValue($_POST, "F_ImageHeight")) ?
        intval(GetArrayValue($_POST, "F_ImageHeight")) : NULL;
$ImageDescription = trim(GetArrayValue($_POST, "F_ImageDescription"));
$Schema = strlen(GetArrayValue($_POST, "F_Schema")) ?
        intval(GetArrayValue($_POST, "F_Schema")) : NULL;
$TitleField = strlen(GetArrayValue($_POST, "F_TitleField")) ?
        intval(GetArrayValue($_POST, "F_TitleField")) : NULL;
$LinkField = strlen(GetArrayValue($_POST, "F_LinkField")) ?
        intval(GetArrayValue($_POST, "F_LinkField")) : NULL;
$DescriptionField = strlen(GetArrayValue($_POST, "F_DescriptionField")) ?
        intval(GetArrayValue($_POST, "F_DescriptionField")) : NULL;
$AuthorField = strlen(GetArrayValue($_POST, "F_AuthorField")) ?
        intval(GetArrayValue($_POST, "F_AuthorField")) : NULL;
$CategoryField = strlen(GetArrayValue($_POST, "F_CategoryField")) ?
        intval(GetArrayValue($_POST, "F_CategoryField")) : NULL;
$Comments = intval(GetArrayValue($_POST, "F_Comments"));
$EnclosureField = strlen(GetArrayValue($_POST, "F_EnclosureField")) ?
        intval(GetArrayValue($_POST, "F_EnclosureField")) : NULL;
$PubDateField = strlen(GetArrayValue($_POST, "F_PubDateField")) ?
        intval(GetArrayValue($_POST, "F_PubDateField")) : NULL;
$ImageField = strlen(GetArrayValue($_POST, "F_ImageField")) ?
        intval(GetArrayValue($_POST, "F_ImageField")) : NULL;

# check for form  errors
if (strlen($CleanUrl) && !preg_match("/^[A-Za-z0-9_]+$/", $CleanUrl))
{
    $H_ErrorMessages->AddMessage("Clean URL must only contain the characters " .
            "A-Z a-z, 0-9, or '_'.");
}
if (!isset($NumItems) || $NumItems <= 0)
{
    $H_ErrorMessages->AddMessage("Number of Items must be a positive integer");
}
if (!isset($Title) || $Title == "")
{
    $H_ErrorMessages->AddMessage("Feed Title is required");
}
if (!isset($Description) || !strlen($Description))
{
    $H_ErrorMessages->AddMessage("Feed Description is required");
}
if (isset($ImageWidth) && ($ImageWidth > 144 || $ImageWidth < 1))
{
    $H_ErrorMessages->AddMessage("Image Width must be <= 144 and >= 1");
}
if (isset($ImageHeight) && ($ImageHeight > 400 || $ImageHeight < 1))
{
    $H_ErrorMessages->AddMessage("Image Height must be <= 144 and >= 1");
}
if (!isset($Schema) || !array_key_exists($Schema, $AllSchemas))
{
    $H_ErrorMessages->AddMessage("A Metadata Schema is required");
}
if (!$TitleField && !$DescriptionField)
{
    $H_ErrorMessages->AddMessage("At least one of Title Metadata Field or " .
            "Description Metadata Field must be set");
}
if (!$PubDateField)
{
    $H_ErrorMessages->AddMessage("A Publication Date Field is required");
}
if (strlen($SearchParameters) &&
        !preg_match("/^[^=?&]+=[^=?&]+(&[^=?&]+=[^=?&]+){0,}$/", $SearchParameters))
{
    $H_ErrorMessages->AddMessage("The supplied search parameters are not a "
            . "valid CWIS search URL ending.");
}

# make sure all the metadata fields are part of the chosen schema
$Fields = array();
if (isset($TitleField)) $Fields["TitleField"] = new MetadataField($TitleField);
if (isset($LinkField)) $Fields["LinkField"] = new MetadataField($LinkField);
if (isset($DescriptionField)) $Fields["DescriptionField"] = new MetadataField($DescriptionField);
if (isset($AuthorField)) $Fields["AuthorField"] = new MetadataField($AuthorField);
if (isset($CategoryField)) $Fields["CategoryField"] = new MetadataField($CategoryField);
if (isset($EnclosureField)) $Fields["EnclosureField"] = new MetadataField($EnclosureField);
if (isset($PubDateField)) $Fields["PubDateField"] = new MetadataField($PubDateField);
if (isset($ImageField)) $Fields["imageField"] = new MetadataField($ImageField);
foreach ($Fields as $Field)
{
    if (intval($Field->SchemaId()) != $Schema)
    {
        $H_ErrorMessages->AddMessage($Field->GetDisplayName() .
                " is not part of the chosen Metadata Schema");
    }
}

# if there are error messages, bounce back to the editing page
if ($H_ErrorMessages->HasErrors())
{
    # save the error messages
    $_SESSION["H_ErrorMessages"] = serialize($H_ErrorMessages);

    # save all the form variables for the editing page to access
    $_SESSION["CleanUrl"] = $CleanUrl;
    $_SESSION["NumItems"] = $NumItems;
    $_SESSION["ShowResourceImages"] = $ShowResourceImages;
    $_SESSION["NotifyBrowser"] = $NotifyBrowser;
    $_SESSION["Title"] = $Title;
    $_SESSION["Description"] = $Description;
    $_SESSION["Copyright"] = $Copyright;
    $_SESSION["ManagingEditor"] = $ManagingEditor;
    $_SESSION["WebMaster"] = $WebMaster;
    $_SESSION["LastBuildDate"] = $LastBuildDate;
    $_SESSION["Category"] = $Category;
    $_SESSION["SearchParameters"] = $SearchParameters;
    $_SESSION["ImageUrl"] = $ImageUrl;
    $_SESSION["ImageWidth"] = $ImageWidth;
    $_SESSION["ImageHeight"] = $ImageHeight;
    $_SESSION["ImageDescription"] = $ImageDescription;
    $_SESSION["SchemaId"] = $Schema;
    $_SESSION["TitleFieldId"] = $TitleField;
    $_SESSION["LinkFieldId"] = $LinkField;
    $_SESSION["DescriptionFieldId"] = $DescriptionField;
    $_SESSION["AuthorFieldId"] = $AuthorField;
    $_SESSION["CategoryFieldId"] = $CategoryField;
    $_SESSION["Comments"] = $Comments;
    $_SESSION["EnclosureFieldId"] = $EnclosureField;
    $_SESSION["PubDateFieldId"] = $PubDateField;
    $_SESSION["ImageFieldId"] = $ImageField;

    $AF->SetJumpToPage("index.php?P=P_RSSExport_EditFeed&ID=" . $Id);
    return;
}

# get a connection to the database
$DB = new Database();

# if we are creating a new feed
if ($Id == "NEW")
{
    $Feed = new RSSExport_Feed();
}
# otherwise we are updating an existing feed
else
{
    $Id = intval($Id);
    $Feed = new RSSExport_Feed($Id);
}

# do the update of feed settings
$Feed->CleanUrl($CleanUrl);
$Feed->NumItems($NumItems);
$Feed->ShowResourceImages($ShowResourceImages);
$Feed->NotifyBrowser($NotifyBrowser);
$Feed->Title($Title);
$Feed->Description($Description);
$Feed->Copyright($Copyright);
$Feed->ManagingEditor($ManagingEditor);
$Feed->WebMaster($WebMaster);
$Feed->LastBuildDate($LastBuildDate);
$Feed->Category($Category);
$Feed->SearchParameters($SearchParameters);
$Feed->ImageUrl($ImageUrl);
$Feed->ImageWidth($ImageWidth);
$Feed->ImageHeight($ImageHeight);
$Feed->ImageDescription($ImageDescription);
$Feed->SchemaId($Schema);
$Feed->TitleFieldId($TitleField);
$Feed->LinkFieldId($LinkField);
$Feed->DescriptionFieldId($DescriptionField);
$Feed->AuthorFieldId($AuthorField);
$Feed->CategoryFieldId($CategoryField);
$Feed->Comments($Comments);
$Feed->EnclosureFieldId($EnclosureField);
$Feed->PubDateFieldId($PubDateField);
$Feed->ImageFieldId($ImageField);

# go to the appropriate page
$AF->SetJumpToPage("index.php?P=P_RSSExport_ListFeeds");
