<?PHP
#
#   FILE:  EditClassification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* print class segment name
*/
function PrintClassSegmentName()
{
    global $Class;

    print(defaulthtmlspecialchars($Class->SegmentName()));
}

/**
* print class full name
*/
function PrintClassFullName()
{
    global $Class;
    print($Class->FullName());
}

/**
* print class id
*/
function PrintClassId()
{
    global $Class;
    print($Class->Id());
}

/**
* return if ok to delete class (true) or not (false)
*/
function OkayToDeleteClass()
{
    global $Class;
    return (($Class->ResourceCount() == 0) && ($Class->ChildCount() == 0))
            ? TRUE : FALSE;
}

/**
* function to determine if field has itemlevelqualifiers or not
*/
function UsesQualifiers()
{
    global $Class;
    $Field = new MetadataField($Class->FieldId());

    return $Field->UsesQualifiers();
}

/**
* print Qualifier option list
*/
function PrintQualifierList()
{
    global $Class;

    $Field = new MetadataField($Class->FieldId());

    if ($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        # get current qualifier or use the default qualifier if not set
        $QualifierId = $Class->QualifierId();
        if (is_null($QualifierId))
        {
            $QualifierId = $Field->DefaultQualifier();
        }

        $OptList = new HtmlOptionList("F_QualifierId", $Items, $QualifierId);
        $OptList->PrintIfEmpty(FALSE);
        $OptList->PrintHtml();
    }
    else if ($Field->DefaultQualifier() > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier))
        {
            print $Qualifier->Name();
        }
    }
    else
    {
        print "None";
    }

}

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Class;

PageTitle("Edit Classification");

# check if current user is authorized
if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

# retrieve class info from DB
$Class = new Classification($_GET["ClassificationId"]);

# prepare error list for print
if (isset($_SESSION["ErrorMessages"]))
{
    $H_ErrorList = $_SESSION["ErrorMessages"];
}

/**
* Clean error messages out of Session.
*/
function ClearErrorMessages()
{
    if (isset($_SESSION["ErrorMessages"]))
    {
        unset($_SESSION["ErrorMessages"]);
    }
}
$AF->AddPostProcessingCall("ClearErrorMessages");
