<?PHP

$GLOBALS["G_ErrMsg"] = Install_LoadDefaultConfig();

/**
* Load the default configuration for a new CWIS installation.
*/
function Install_LoadDefaultConfig()
{
    Install_LoadDefaultSystemConfiguration();
}

/**
* Load the default system configuration.
*/
function Install_LoadDefaultSystemConfiguration()
{
    # add a row for the system configuration
    $Database = new Database();
    $Database->Query("INSERT INTO SystemConfiguration VALUES ()");

    # update the system configuration
    $SysConfig = $GLOBALS["G_SysConfig"];
    $SysConfig->TopLinkString("");
    $SysConfig->PortalName("Online Resource Portal");
    $SysConfig->AdminEmail("webmaster@localhost");
    $SysConfig->NumClassesPerBrowsePage(80);
    $SysConfig->BrowsingFieldId(6);
    $SysConfig->PasswordMailSubject("New Login for X-PORTALNAME-X (X-USERNAME-X)");
    $SysConfig->PasswordMailBody("\nThank you for signing up on X-PORTALNAME-X!\n\nTo activate your new login, please click on the link below:\n\n   X-ACTIVATIONURL-X\n\nIf the link doesn't work you can also go to this address:\n\n   X-MANUALACTIVATIONURL-X\n\nAnd enter your user name and activation code:\n\n   Name:  X-USERNAME-X\n   Code:  X-ACTIVATIONCODE-X\n\nWe're looking forward to seeing you online!");
    $SysConfig->PasswordResetMailSubject("X-PORTALNAME-X Password Change");
    $SysConfig->PasswordResetMailBody("Someone (presumably you) has asked to change your password on X-PORTALNAME-X for the account X-USERNAME-X.\n\nTo change your password, please click on this link:\n\n  X-RESETURL-X\n\nIf that link doesn't work you can also go to this address:\n\n   X-MANUALRESETURL-X\n\nAnd enter your user name and password reset code:\n\n   Name:  X-USERNAME-X\n   Code:  X-RESETCODE-X\n\nYour password will remain the same until changed via one of the above links.\n\n\nFor reference, the password change request came from address X-IPADDRESS-X and this e-mail was sent to X-EMAILADDRESS-X.");
    $SysConfig->MailChangeMailSubject("X-PORTALNAME-X mail address change request");
    $SysConfig->MailChangeMailBody("Someone (presumably you) has requested that the email address registered at X-PORTALNAME-X for the account X-USERNAME-X be changed from X-EMAILADDRESS-X to X-NEWEMAILADDRESS-X.\n\nTo confirm this change, please click on this link:\n\n  X-CHANGEURL-X\n\nIf that link doesn't work you can also go to this address:\n\n  X-MANUALCHANGEURL-X\n\nAnd enter your user name and confirmation code:\n\n   Name:  X-USERNAME-X\n\n   Code:  X-CHANGECODE-X\n\nIf you don't want to change your email, just ignore this message and nothing will be done.\n\nFor reference, the password change request came from address X-IPADDRESS-X and this e-mail was sent to X-NEWEMAILADDRESS-X");
    $SysConfig->SearchTermsRequired(1);
    $SysConfig->DefaultCharacterSet("UTF-8");
    $SysConfig->LegalNotice("Sample Content Copyright 1999-2015 Internet Scout Research Group");
    $SysConfig->DefaultActiveUI("default");
    $SysConfig->CurrentTheme("default");
    $SysConfig->DefaultUserPrivs(array(PRIV_POSTTOFORUMS, PRIV_POSTCOMMENTS));
}
