<?PHP
#
#   FILE:  GoTo.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

# if resource ID was specified
if (isset($_GET["ID"]))
{
    # grab resource ID
    $ResourceId = $_GET["ID"];

    # if resource ID is valid
    if (Resource::ItemExists($ResourceId))
    {
        # if metadata field was specified
        $Resource = new Resource($ResourceId);
        if (isset($_GET["MF"]))
        {
            # if specified metadata field is valid
            if ($Resource->Schema()->FieldExists($_GET["MF"]))
            {
                # use specified metadata field
                $FieldId = $_GET["MF"];
            }
        }
        else
        {
            # if there is a standard URL field for resource
            $StdUrlFieldId = $Resource->Schema()->StdNameToFieldMapping("Url");
            if ($StdUrlFieldId !== NULL)
            {
                # use standard URL field
                $FieldId = $StdUrlFieldId;
            }
        }

        # if we have a metadata field ID
        if (isset($FieldId))
        {
            # if URL field was specified and user has permission to view it
            $Field = $Resource->Schema()->GetField($FieldId);
            if (($Field->Type() == MetadataSchema::MDFTYPE_URL)
                    && ($Resource->UserCanViewField($GLOBALS["G_User"], $Field)))
            {
                # load URL to go to
                $Url = $Resource->Get($Field);

                # allow plugins to modify the value
                $SignalResult = $AF->SignalEvent(
                    "EVENT_FIELD_DISPLAY_FILTER", array(
                        "Field" => $Field,
                        "Resource" => $Resource,
                        "Value" => $Url));
                $Url = $SignalResult["Value"];

                # don't use URLs that are definitely invalid
                if (filter_var($Url, FILTER_VALIDATE_URL) === FALSE)
                {
                    unset($Url);
                }
            }
        }
    }
}

# if we found URL to go to
if (isset($Url))
{
    # signal URL click event
    $AF->SignalEvent("EVENT_URL_FIELD_CLICK", array(
            "ResourceId" => $Resource->Id(),
            "FieldId" => $Field->Id()));

    # go to page specified by URL
    $AF->SetJumpToPage($Url);
}
else
{
    # return to calling page
    $AF->SetJumpToPage(
            isset($_SERVER["HTTP_REFERER"]) ?
            $_SERVER["HTTP_REFERER"] :
            ApplicationFramework::BaseUrl()."index.php");
}
