<?PHP
#
#   FILE:  SysAdmin.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("System Administration");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print OaiHarvest URL.
*/
function PrintOaiHarvestLink()
{
    print ApplicationFramework::BaseUrl()."index.php?P=OAI";
}

/**
* Print OaiTest URL.
*/
function PrintOaiTestLink()
{
    $OurUrl = ApplicationFramework::BaseUrl()."OAI";
    $Link = "http://re.cs.uct.ac.za/cgi-bin/Explorer/2.0-1.46/testoai?"
            ."metadataPrefix=oai_dc&amp;archive=".$OurUrl;
    print $Link;
}

/**
* Print support format names.
*/
function PrintSupportedFormatNames()
{
    $FormatNames = Image::SupportedFormatNames();
    $count = count($FormatNames);
    foreach ( $FormatNames as $Name )
    {
        print $Name;
        if ( --$count != 0 ) {  print ", ";  }
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------



# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN, PRIV_USERADMIN))
        {  return;  }

# make sure information for current user is up-to-date
$GLOBALS["G_User"]->LastLocation($GLOBALS["AF"]->GetPageName());

$UserFactory = new CWUserFactory();
$H_LoggedInUsers = $UserFactory->GetLoggedInUsers();
$H_RecentlyLoggedInUsers = $UserFactory->GetRecentlyLoggedInUsers();

$DB = new Database();
$H_ServerVersion = $DB->GetServerVersion(TRUE);
