<?PHP
#
#   FILE:  F-Blog_PrintBlogEntry.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print a blog entry.
* @param Blog_Entry $Entry Blog entry to print.
*/
function Blog_PrintBlogEntry(Blog_Entry $Entry)
{
    static $Blog;

    $GLOBALS["AF"]->RequireUIFile("P_Blog.css");

    if (!isset($Blog))
    {
        $Blog = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");
        $Blog->SetCurrentBlog($Entry->GetBlogId());
    }

    $SafeId = defaulthtmlentities($Entry->Id());
    $SafeUrl = defaulthtmlentities($Entry->EntryUrl());
    $SafeTitle = $Entry->TitleForDisplay();
    $SafeAuthor = defaulthtmlentities($Entry->AuthorForDisplay());
    $SafeEditor = defaulthtmlentities($Entry->EditorForDisplay());
    $SafeCreationDate = defaulthtmlentities($Entry->CreationDateForDisplay());
    $SafeModificationDate = defaulthtmlentities($Entry->ModificationDateForDisplay());
    $SafePublicationDate = defaulthtmlentities($Entry->PublicationDateForDisplay());
    $SafePublicationDatePrefix = defaulthtmlentities(
            $Entry->PublicationDateDisplayPrefix());
    $SafePublicationDateForParsing = defaulthtmlentities(
            $Entry->PublicationDateForParsing());
    $SafeNumberOfComments = defaulthtmlentities($Entry->NumberOfComments());
    $Teaser = Blog_GetEntryTeaser($Entry, $Blog->MaxTeaserLength());
    $Categories = $Entry->CategoriesForDisplay();
    $PrintMoreLink = strlen($Entry->Body()) > strlen($Teaser);
    // @codingStandardsIgnoreStart
    ?>
  <article class="blog-entry blog-short" itemscope="itemscope" itemtype="http://schema.org/BlogPosting">
    <link itemprop="url" href="<?PHP print $SafeUrl; ?>" />
    <header class="blog-header">
      <?PHP if ($Entry->UserCanEdit($GLOBALS["G_User"])) { ?>
        <div class="cw-table cw-table-fullsize cw-table-fauxtable cw-content-complexheader">
          <div class="cw-table-fauxrow">
            <div class="cw-table-fauxcell">
              <h1 class="blog-title">
                <a href="index.php?P=P_Blog_Entry&amp;ID=<?PHP print $SafeId; ?>">
                  <span itemprop="headline"><?PHP print $SafeTitle; ?></span>
                </a>
              </h1>
            </div>
            <div class="cw-table-fauxcell">
              <a class="cw-button cw-button-elegant" href="index.php?P=EditResource&amp;ID=<?PHP print $SafeId; ?>">Edit</a>
            </div>
          </div>
        </div>
      <?PHP } else { ?>
        <h1 class="blog-title">
          <a href="index.php?P=P_Blog_Entry&amp;ID=<?PHP print $SafeId; ?>">
            <span itemprop="headline"><?PHP print $SafeTitle; ?></span>
          </a>
        </h1>
      <?PHP } ?>
      <p>Posted
        <?PHP if ($Blog->ShowAuthor()) { ?>
          by <span class="blog-author" itemprop="author" itemscope="itemscope" itemtype="http://schema.org/Person">
            <span itemprop="name"><?PHP print $SafeAuthor; ?></span>
          </span>
        <?PHP } ?>
        <?PHP print $SafePublicationDatePrefix; ?>
        <time class="blog-date" itemprop="datePublished" datetime="<?PHP print $SafePublicationDateForParsing; ?>">
          <?PHP print $SafePublicationDate; ?></time>.</p>
    </header>

    <div class="blog-teaser" itemprop="articleBody">
      <?PHP print $Teaser; ?>
    </div>

    <?PHP if (!count($Categories) || !$PrintMoreLink) { ?>
    <section class="share" aria-label="sharing buttons">
      <?PHP $Blog->PrintShareButtonsForEntry($Entry, 16, "grey"); ?>
    </section>
    <?PHP } ?>

    <?PHP if (count($Categories)) { ?>
      <strong>Categories:</strong>
      <ul class="cw-list cw-list-noindent cw-list-nobullets cw-list-horizontal cw-list-separated blog-categories" itemprop="keywords">
        <?PHP Blog_PrintCategories($Categories); ?>
      </ul>
    <?PHP } ?>

    <?PHP if (count($Categories) && $PrintMoreLink) { ?>
    <section class="share" aria-label="sharing buttons">
      <?PHP $Blog->PrintShareButtonsForEntry($Entry, 16, "grey"); ?>
    </section>
    <?PHP } ?>

    <?PHP if ($PrintMoreLink) {  ?>
      <p>
        <a class="blog-more" href="index.php?P=P_Blog_Entry&amp;ID=<?PHP print $SafeId; ?>">
          <span class="blog-bullet">&raquo;</span> Read More<?PHP if ($Blog->EnableComments()) print " or Comment"; ?></a>
      </p>
    <?PHP } ?>
  </article>
    <?PHP
    // @codingStandardsIgnoreEnd
}

/**
* Get the blog entry teaser with the image inserted in it, if it is available.
* @param Blog_Entry $Entry Blog entry.
* @param int $MaxLength The maximum length of the teaser.
* @return Returns the blog entry teaser with the image inserted in it, if it is
*      available.
*/
function Blog_GetEntryTeaser(Blog_Entry $Entry, $MaxLength)
{
    $Teaser = $Entry->Teaser($MaxLength);
    $Image = $Entry->Image();

    # if there is no image associated with the blog entry
    if (is_null($Image))
    {
        return $Teaser;
    }

    # create the image tag
    $SafeImage = defaulthtmlentities($Entry->ThumbnailForDisplay());
    $SafeImageAlt = defaulthtmlentities($Entry->ImageAltForDisplay());
    $ImageInsert = '<div class="blog-image-wrapper">';
    $ImageInsert .= '<img class="blog-image" src="'.$SafeImage
            .'" alt="'.$SafeImageAlt.'" />';
    $ImageInsert .= '</div>';

    # return the teaser with the image inserted at the beginning
    return substr_replace($Teaser, $ImageInsert, 0, 0);
}

/**
* Print blog entry categories.
* @param array $Categories Blog entry categories to print.
*/
function Blog_PrintCategories(array $Categories)
{
    foreach ($Categories as $Category)
    {
        $SafeCategory = defaulthtmlentities($Category);
        ?><li><i><?= $Category ?></i></li><?PHP
    }
}
