<?PHP
#
#   FILE:  Event.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$H_Plugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# assume that a generic error will occur
$H_State = "Error";

# get object parameters
$EventId = GetArrayValue($_GET, "EventId");

# if the event ID looks invalid
if (!is_numeric($EventId))
{
    $H_State = "Invalid ID";
    return;
}

# if the event ID actually is invalid
if (!CalendarEvents_Event::ItemExists($EventId))
{
    $H_State = "Invalid ID";
    return;
}

$H_Event = new CalendarEvents_Event($EventId);

# if the entry is some other type of resource
if (!$H_Plugin->IsEvent($H_Event))
{
    $H_State = "Not Event";
    return;
}

# if the user can't view the event
if (!$H_Event->UserCanView($GLOBALS["G_User"]))
{
    $H_State = "Viewing not permitted";
    return;
}

# get the events's metrics
$H_Metrics = $H_Plugin->GetEventMetrics($H_Event);

# record an event
$H_Plugin->RecordEventView($H_Event);

# everything is fine
$H_State = "OK";

# signal view of full event info
$GLOBALS["AF"]->SignalEvent("EVENT_FULL_RECORD_VIEW",
        array("ResourceId" => $EventId));
