<?PHP

/**
* Display the folders sidebar content html.
* @param string $ViewFolderLink the URL to view the displayed folder
* @param string $FolderName the name of the folder if it has one, otherwise empty string
* @param boolean $HasResources if the folder contains any resources
* @param array $ResourceInfo limited array of resource information to be iterated
* through and displayed
* @param boolean $HasMoreResources if the folder contains more resources than
* in $ResourceInfo
*/
function Folders_PrintFolderSidebarContent()
{
    global $G_User;
    $FoldersPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Folders");
    $FolderFactory = new Folders_FolderFactory($G_User->Id());
    $FolderId = $FolderFactory->GetSelectedFolder()->Id();
    $Folder = new Folders_Folder($FolderId);
    $SelectedFolder = $FoldersPlugin->GetSelectedFolder($G_User);
    $Name = $SelectedFolder->Name();

    $FolderName = StdLib::NeatlyTruncateString($Name, 18);

    $ViewFolderLink = $GLOBALS['AF']->BaseUrl().
        "index.php?P=P_Folders_ViewFolder&amp;FolderId=".$FolderId;

    $ItemIds = $SelectedFolder->GetItemIds();
    $ItemCount = count($ItemIds);
    $HasResources = $ItemCount > 0;
    $NumDisplayedResources = $FoldersPlugin->ConfigSetting("NumDisplayedResources");
    $HasMoreResources = $ItemCount > $NumDisplayedResources;
    $ResourceInfo = array();

    foreach ($ItemIds as $ResourceId)
    {
        $Resource = new Resource($ResourceId);
        $Title = Folders_Common::GetSafeResourceTitle($Resource);

        # get the schema name associated with this resource
        $Schema = new MetadataSchema($Resource->SchemaId());
        $SchemaName = $Schema->Name();
        $SchemaCSSName = "cw-sidebar-resource-tag-" .
            str_replace(array(" ", "/"), '', strtolower($SchemaName));
        $SchemaName = $Schema->AbbreviatedName();

        $ResourceInfo[$ResourceId] = array(
            "ResourceId" => $Resource->Id(),
            "ResourceTitle" => StdLib::NeatlyTruncateString($Title, 24),
            "ResourceSchemaName" => $SchemaName,
            "ResourceSchemaCSSName" => $SchemaCSSName);

        # only display the first $NumDisplayedResources
        if (count($ResourceInfo) >= $NumDisplayedResources)
        {
            break;
        }
    }
// @codingStandardsIgnoreStart
?>
  <!-- BEGIN FOLDERS SIDEBAR DISPLAY -->
  <div class="cw-section cw-section-simple cw-html5-section cw-folders-sidebar">
    <div class="cw-section-header cw-html5-header">
    <a href="<?PHP print defaulthtmlentities($ViewFolderLink);?>">
        <?PHP if($FolderName) { ?>
          <strong><?PHP print defaulthtmlentities($FolderName); ?></strong>
        <?PHP } else { ?>
          <strong>Current Folder</strong>
        <?PHP } ?>
      </a>
      <a class="cw-button cw-button-constrained cw-button-elegant" href=<?PHP print $GLOBALS["AF"]->BaseUrl()."index.php?P=P_Folders_ManageFolders"?>>Manage</a>
    </div>
    <div class="cw-section-body">
      <?PHP if ($HasResources) { ?>
        <ul class="cw-list cw-list-noindent cw-list-dotlist">
          <?PHP foreach ($ResourceInfo as $Info) { extract($Info); ?>
            <li class="cw-folders-sidebar-folder-resource <?PHP print defaulthtmlentities($ResourceId); ?>">
              <span class="cw-sidebar-resource-tag <?PHP print($ResourceSchemaCSSName); ?>"><?PHP print($ResourceSchemaName); ?></span>
              <a href="index.php?P=FullRecord&amp;ID=<?PHP print defaulthtmlentities($ResourceId); ?>">
                <?PHP print $ResourceTitle; ?>
              </a>
            </li>
          <?PHP } ?>
        </ul>
        <?PHP if ($HasMoreResources) { ?>
        <a class="cw-folders-seeall" href="<?PHP print defaulthtmlentities($ViewFolderLink);?>">See all &rarr;</a>
        <?PHP } ?>
      <?PHP } else { ?>
        <p class="cw-folders-noitems">There are no resources in this folder.</p>
      <?PHP } ?>
    </div>
  </div>
  <!-- END FOLDERS SIDEBAR DISPLAY -->
<?PHP
// @codingStandardsIgnoreEnd
}
