<?PHP
#
#   FILE:  ChangeResourceNote.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $Folder;
global $FolderId;
global $ItemId;
global $Note;
global $ReturnTo;

PageTitle("Change Resource Note");

# make sure the user is logged in
if (!CheckAuthorization())
{
    return;
}

$FolderId = GetFormValue("FolderId");
$ItemId = GetFormValue("ItemId");

# redirect if no IDs are given
if (!strlen($FolderId) || !strlen($ItemId))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

$FolderFactory = new Folders_FolderFactory($GLOBALS["G_User"]->Id());
$ResourceFolder = $FolderFactory->GetResourceFolder();
try
{
    $Folder = new Folders_Folder($FolderId);
}
catch (Exception $Exception)
{
    # redirect if given a bad folder ID
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

# redirect if the user should not see the folder
if (!$ResourceFolder->ContainsItem($Folder->Id()))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

# make sure the resource is valid and belongs to the folder
if (!Resource::ItemExists($ItemId) || !$Folder->ContainsItem($ItemId))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

$Note = $Folder->NoteForItem($ItemId);
$ReturnTo = defaulthtmlentities(GetFormValue("ReturnTo"));
