<?PHP
#
#   FILE:  GetKML.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

$AF->SuppressHTMLOutput();

$PointProvider = GetArrayValue($_GET, "PP");
$DetailProvider = GetArrayValue($_GET, "DP");

# only continue if given the parameters
if ($PointProvider && $DetailProvider)
{
    $GMaps = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

    $Path = $GMaps->GetKml($PointProvider, $DetailProvider);

    if (file_exists($Path))
    {
        # send the file but unbuffered to avoid memory issues
        header('Content-type: application/vnd.google-earth.kml+xml');
        $AF->AddUnbufferedCallback("readfile", array($Path));
    }
    else
    {
        # if kml could not be generated, return an error
        header($_SERVER["SERVER_PROTOCOL"]." 500 Internal Server Error");
        print "ERROR: Unable to generate KML. "
            ."Server admin can check cwis.log for details.";
    }
}
