<?PHP

/**
 * Class that builds on the foldering functionality to provide groups of
 * metadata fields.
 */
class MetadataFieldGroup extends Folder
{

    /**
     * Get the items of the metadata field group as objects instead of IDs.
     * @return array an array of metadata field objects
     */
    public function GetFields()
    {
        $ItemIds = $this->GetItemIds();
        $Items = array();

        foreach ($ItemIds as $Info)
        {
            $Items[] = new $Info["Type"]($Info["ID"]);
        }

        return $Items;
    }

    /**
     * Get the number of metadata fields this group holds.
     * @return int the number of metadata fields this group holds
     */
    public function GetFieldCount()
    {
        if (!isset($this->FieldCount))
        {
            $this->FieldCount = count($this->GetItemIds());
        }

        return $this->FieldCount;
    }

    /**
     * @var int $FieldCount the number of metadata fields this group holds
     */
    protected $FieldCount;

}
