<?PHP

  /**
   * Generator for text input fields
   * \nosubgrouping
   */ 

class TextFormField extends FormField {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization */
    /*@{*/

    /**
     * Object Constructor.
     * @param Name internal name for this field, used in html id=
     * @param IsRequired
     * @param Label display name for this field, shown to user
     * @param Length Length of the display box
     * @param MaxLength The maximum allowed entry size
     * @param ValidFunc A function to check this field for valid input (OPTIONAL)
     * @param ValidMsgs An array of error messages which should correspond
     *    to the error codes issued by ValidFunc (OPTIONAL)
     */
    function TextFormField(
            $Name, $IsRequired, $Label, $Length, $MaxLength, 
            $ValidFunc = NULL, $ValidMsgs = NULL)
    {
        $this->MyLength = $Length;
        $this->MyMaxLength = $MaxLength;

        $this->FormField($Name, $IsRequired, $Label, $ValidFunc, $ValidMsgs);
    }

    /*@}*/
    
    /** @name Accessors */
    /*@{*/

    /**
     * Get or set the display length for this field
     * @param NewVal (OPTIONAL)
     * @return The current length
     */
    function Length($NewVal = NULL) {  return $this->GetOrSet("MyLength", $NewVal);  }
    
    /**
     * Get or set the maximum input length for this field
     * @param NewVal (OPTIONAL)
     * @return The current max input length
     */
    function MaxLength($NewVal = NULL) {  return $this->GetOrSet("MyMaxLength", $NewVal);  }
    
    /*@}*/
    
    /** @name Display */
    /*@{*/
    
    /**
     * Generate HTML for this object
     * @param DisplayErrorIndicator (OPTIONAL)
     */
    function PrintInput($DisplayErrorIndicator = FALSE)
    {
        print("<input type=\"".
                    # (hack to support PasswordFormField object as well)
                    (method_exists($this, "PasswordFormField") ? "password" : "text")
                    ."\""
                ." name=\"".$this->MyName."\""
                ." value=\"".htmlspecialchars($this->MyValue)."\""
                ." size=\"".$this->MyLength."\""
                ." maxlength=\"".$this->MyMaxLength."\""
                .($DisplayErrorIndicator ? " style=\"background-color: #FFEEEE;\"" : "")
                ." />");
    }
    
    /*@}*/

    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $MyLength;
    private $MyMaxLength;
}


?>
