<?PHP
#
#   FILE:  EditOAIConfigComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   FORM FIELDS EXPECTED:
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

# if save changes was requested
if ($_POST["Submit"] != "Cancel")
{
    # clean out any OAI field mappings that don't have matching SPT fields
    # (possible in old versions of software)
    $DB->Query("SELECT SPTFieldId FROM OAIFieldMappings"
               ." LEFT JOIN MetadataFields ON MetadataFields.FieldId = OAIFieldMappings.SPTFieldId"
               ." WHERE MetadataFields.FieldId IS NULL");
    $DBTwo = new Database();
    while ($FieldId = $DB->FetchField("SPTFieldId"))
    {
        $DBTwo->Query("DELETE FROM OAIFieldMappings WHERE SPTFieldId = '".$FieldId."'");
    }

    $Schema = new MetadataSchema();
    $SPTOAIServer = new SPTOAIServer();

    $FormatList = $SPTOAIServer->FormatList();

    global $F_OaiIdDomain, $F_OaiIdPrefix, $F_OaiEarliestDate,
        $F_OaiDateGranularity;

    # update system configuration parameters first
    $SysConfig->OaiIdDomain($F_OaiIdDomain);
    $SysConfig->OaiIdPrefix($F_OaiIdPrefix);
    $SysConfig->OaiEarliestDate($F_OaiEarliestDate);
    $SysConfig->OaiDateGranularity($F_OaiDateGranularity);

    # next update OAI field mappings
    foreach ($_POST as $Var => $Value)
    {
        foreach ($FormatList as $FormatName)
        {
            # not interested in the other vars
            if (strpos($Var, $FormatName) === FALSE)
                continue;

            $OAIFieldName = $Value;

            # look for field mapping vars
            if (substr_count($Var, "field") > 0)
            {
                $Scanner = "field_".$FormatName."_%d";
                sscanf($Var, $Scanner, $LocalFieldId);
                $Field = $Schema->GetField($LocalFieldId);
                $LocalFieldName = $Field->Name();

                $SPTOAIServer->SetFieldMapping($FormatName,
                    $LocalFieldName, $OAIFieldName);
            }
            # qualifier mapping vars
            else if (substr_count($Var, "qualifier") > 0)
            {
                $Scanner = "qualifier_".$FormatName."_%d";
                sscanf($Var, $Scanner, $QualifierId);
                $Qualifier = new Qualifier($QualifierId);
                $LocalQualifierName = $Qualifier->Name();

                # only set if something selected
                $SPTOAIServer->SetQualifierMapping($FormatName,
                    $LocalQualifierName, $OAIFieldName);
            }
        }
    }

    # go to parent of OAI configuration
    $AF->SetJumpToPage("EditOAIConfig");
}
else
{
    # go to parent of OAI configuration
    $AF->SetJumpToPage("SysAdmin");
}
