<?PHP
#
#   FILE:  MetadataHelp3.php
#
#   FUNCTIONS PROVIDED:
#       None.
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

PageTitle("Metadata Tool - Help - Resource Field Definitions");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintFieldName()
{
    global $FieldName;

    print $FieldName;
}
function PrintDescription()
{
    global $Description;

    print $Description;
}

function PrintFieldDefinitions()
{
    global $FieldName, $Description;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields();
    foreach ($Fields as $Field)
    {
        $FieldName = $Field->GetDisplayName();
        $Description = $Field->Description();
        PrintFieldDefinition();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Description;
global $FieldName;

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_SYSADMIN)) {  return;  }
