<?PHP
#
#   FILE:  RenameMetadataFieldGroup.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Print the fields in the given metadata field group.
 * @param MetadataFieldGroup $Group metadata field group
 * @return void
 */
function PrintGroupItems(MetadataFieldGroup $Group)
{
    foreach ($Group->GetFields() as $Field)
    {
        PrintFieldInGroup($Field);
    }
}

# ----- MAIN -----------------------------------------------------------------

global $Group;

PageTitle("Rename Metadata Field Group");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$GroupId = GetArrayValue($_GET, "GroupId");

try
{
    $Group = new MetadataFieldGroup($GroupId);
}

catch (Exception $Exception)
{
    $AF->SetJumpToPage("MetadataFieldOrdering");
}
