<?PHP
#
#   FILE:  BackwardCompatibility.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class BackwardCompatibility extends Plugin {

    function Register()
    {
        $this->Name = "Backward Compatibility";
        $this->Version = "1.0.0";
        $this->Description = "Improves backwards compatibility with older"
                ." versions of CWIS";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.3.2");
        $this->EnabledByDefault = FALSE;
    }

    function Initialize()
    {
        # set up possible old UI directories and file names to be included
        #       when searching for UI files
        $GLOBALS["AF"]->AddIncludeDirectories(array(
                "local/interface/%ACTIVEUI%/include/SPT--",
                "local/interface/SPT--%ACTIVEUI%/include/SPT--",
                "interface/%ACTIVEUI%/include/SPT--",
                "SPTUI--%ACTIVEUI%/include/",
                "SPTUI--%ACTIVEUI%/include/SPT--",
                "%ACTIVEUI%/include/",
                "%ACTIVEUI%/include/SPT--",
                "local/interface/default/include/SPT--",
                "interface/default/include/SPT--",
                ), TRUE, TRUE);
        $GLOBALS["AF"]->AddInterfaceDirectories(array(
                "local/interface/%ACTIVEUI%/SPT--",
                "local/interface/SPT--%ACTIVEUI%/SPT--",
                "interface/%ACTIVEUI%/SPT--",
                "SPTUI--%ACTIVEUI%/",
                "SPTUI--%ACTIVEUI%/SPT--",
                "%ACTIVEUI%/",
                "%ACTIVEUI%/SPT--",
                "local/interface/default/SPT--",
                "interface/default/SPT--",
                ), TRUE, TRUE);
        $GLOBALS["AF"]->AddImageDirectories(array(
                "local/interface/SPT--%ACTIVEUI%/images/",
                "SPTUI--%ACTIVEUI%/images/",
                "%ACTIVEUI%/images/",
                ), TRUE, TRUE);
        $GLOBALS["AF"]->AddFunctionDirectories(array(
                "local/interface/SPT--%ACTIVEUI%/include/",
                "SPTUI--%ACTIVEUI%/include/",
                "%ACTIVEUI%/include/",
                ), TRUE, TRUE);

        # report that initialization was successful
        return NULL;
    }

}
