<?PHP

class BotDetector extends Plugin {

    function Register()
    {
        $this->Name = "Bot Detector";
        $this->Version = "1.0.0";
        $this->Description = "Provides support for detecting whether the"
                ." current page load is by an actual person or by an automated"
                ." <a href=\"http://en.wikipedia.org/wiki/Web_crawler\""
                ." target=\"_blank\">web crawler or spider</a>.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array("CWISCore" => "2.1.0");
        $this->EnabledByDefault = TRUE;
    }

    function DeclareEvents()
    {
        return array(
                "BotDetector_EVENT_CHECK_FOR_BOT"
                        => ApplicationFramework::EVENTTYPE_FIRST,
                );
    }

    function HookEvents()
    {
        return array(
                "BotDetector_EVENT_CHECK_FOR_BOT" => "CheckForBot",
                );
    }

    function CheckForBot()
    {
        # If there's no user-agent, skip the bot check and assume that
        # we're dealing with a human.
        if (isset($_SERVER['HTTP_USER_AGENT']))
        {
            # Patterns borrowed from awstats list of common robots
            # in awstats-7.0, this is in lib/robots.pm line 334
            $Robots = array(
                'appie', 'architext', 'jeeves', 'bjaaland', 'contentmatch',
                'ferret', 'googlebot', 'google\-sitemaps', 'gulliver',
                'virus[_+ ]detector', 'harvest', 'htdig', 'linkwalker',
                'lilina', 'lycos[_+ ]', 'moget', 'muscatferret', 'myweb',
                'nomad', 'scooter', 'slurp', '^voyager\/', 'weblayers',
                'antibot', 'bruinbot', 'digout4u', 'echo!',
                'fast\-webcrawler', 'ia_archiver\-web\.archive\.org',
                'ia_archiver', 'jennybot', 'mercator', 'netcraft',
                'msnbot\-media', 'msnbot', 'petersnews', 'relevantnoise\.com',
                'unlost_web_crawler', 'voila', 'webbase', 'webcollage',
                'cfetch', 'zyborg', 'wisenutbot', 'bingbot', 'yandexbot');

            foreach ($Robots as $Robot)
            {
                if (preg_match('/'.$Robot.'/i', $_SERVER['HTTP_USER_AGENT']))
                {
                    return TRUE;
                }
            }
        }
        return FALSE;
    }
}

?>
