<?PHP
#
#   FILE:  ListPages.php (Pages plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

# check authorization to see page list
$Plugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
CheckAuthorization($Plugin->ConfigSetting("PrivilegeToAuthor"),
        $Plugin->ConfigSetting("PrivilegeToEdit"));

# load page IDs
$PFactory = new Pages_PageFactory();
$PageIds = $PFactory->GetItemIds();

# get total count of pages
$H_PageCount = count($PageIds);

# prune page IDs down to just currently-selected segment
$H_StartingIndex = isset($_GET["SI"]) ? $_GET["SI"] : 0;
$H_PagesPerPage = 25;
$PageIds = array_slice($PageIds, $H_StartingIndex, $H_PagesPerPage);

# load pages from page IDs
$H_Pages = array();
foreach ($PageIds as $Id)
{
    $H_Pages[$Id] = new Pages_Page($Id);
}

