<?PHP

#
#   FILE:  StartUp.php
#
#   USAGE:  This file initializes the CWIS operating environment, and may be
#       included in non-CWIS files that use the CWIS user login mechanism or
#       other facilities internal to CWIS.
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

# save our current directory then change to CWIS base directory
$StartingDir = getcwd();
chdir(dirname(__FILE__)."/..");

# turn error reporting up to max if running local or at Scout
if (($_SERVER["HTTP_HOST"] == "localhost")
        || ($_SERVER["HTTP_HOST"] == "test.scout.wisc.edu"))
{
    error_reporting(E_ALL|E_STRICT);
    # (set time zone to prevent PHP local time zone warning from E_STRICT)
    date_default_timezone_set("America/Chicago");
}

# load base configuration
require_once("config.php");
require_once("lib/AxisPHP/Axis--Database.php");
Database::SetGlobalServerInfo($SPT_DBUserName, $SPT_DBPassword, $SPT_DBHost);
Database::SetGlobalDatabaseName($SPT_DBName);
if (get_cfg_var("display_errors"))
{
    Database::DisplayQueryErrors(TRUE);
}

# increase session data timeout to eight hours if not already modified from default
if (ini_get("session.gc_maxlifetime") == 1440)
{
    ini_set("session.gc_maxlifetime", 28800);
}

# initialize application framework
require_once("lib/ScoutLib/ApplicationFramework.php");
$ObjectDirectories = array(
        "local/objects" => "",
        "objects" => "",
        "lib/AxisPHP" => "Axis--",
        "lib/ScoutLib" => "",
        );
if (is_dir("local/objects")) {  $ObjectDirectories["local/objects"] = "";  }
$AF = new ApplicationFramework($ObjectDirectories);
require_once("include/Events.php");
$AF->AddEnvInclude("include/Compat.php");

# set up environment
require_once("include/Compat.php");
CreateCompatabilityLinks();
require_once("include/StdLib.php");
require_once("include/EnvSetup.php");
$AF->HtmlCharset($G_SysConfig->DefaultCharacterSet());

# load plugins
$PluginDirs = array(
        "plugins",
        "local/plugins",
        );
$G_PluginManager = new PluginManager($AF, $PluginDirs);
$G_PluginManager->LoadPlugins();

MetadataSchema::SetOwnerListRetrievalFunction(
    array($G_PluginManager, "GetActivePluginList"));
MetadataSchema::NormalizeOwnedFields();

# return to original directory
chdir($StartingDir);
