ALTER TABLE MetadataFields ADD COLUMN UpdateMethod
  ENUM("NoAutoUpdate","OnRecordCreate","Button","OnRecordEdit",
       "OnRecordChange") DEFAULT "NoAutoUpdate";

UPDATE MetadataFields SET UpdateMethod="OnRecordCreate"
  WHERE FieldName="Date of Record Creation";

UPDATE MetadataFields SET UpdateMethod="OnRecordChange"
  WHERE FieldName="Date Last Modified";

ALTER TABLE SystemConfiguration ADD COLUMN TitleField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN DescriptionField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN UrlField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN ScreenshotField INT DEFAULT -1;
ALTER TABLE SystemConfiguration ADD COLUMN SecureLogin INT DEFAULT 1;
ALTER TABLE SystemConfiguration ADD COLUMN MailChangeMailSubject TEXT;
ALTER TABLE SystemConfiguration ADD COLUMN MailChangeMailBody TEXT;

UPDATE SystemConfiguration SET TitleField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Title');
UPDATE SystemConfiguration SET DescriptionField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Description');
UPDATE SystemConfiguration SET UrlField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Url');
UPDATE SystemConfiguration SET ScreenshotField = (SELECT FieldId FROM MetadataFields WHERE FieldName = 'Screenshot');

INSERT INTO SystemConfiguration (MailChangeMailSubject, MailChangeMailBody)
  VALUES
  ('X-PORTALNAME-X email address change request',
   'Someone (presumably you) has requested that the email address registered at X-PORTALNAME-X for the account X-USERNAME-X be changed from X-EMAILADDRESS-X to X-NEWEMAILADDRESS-X.\n\nTo confirm this change, please click on this link:\n\n  X-CHANGEURL-X\n\nIf that link doesn\'t work you can also go to this address:\n\n  X-MANUALCHANGEURL-X\n\nAnd enter your user name and confirmation code:\n\n   Name:  X-USERNAME-X\n\n   Code:  X-CHANGECODE-X\n\nIf you don\'t want to change your email, just ignore this message and nothing will be done.\n\nFor reference, the password change request came from address X-IPADDRESS-X and this e-mail was sent to X-NEWEMAILADDRESS-X');

ALTER TABLE APUsers ADD COLUMN SearchSelections TEXT;
ALTER TABLE APUsers ADD COLUMN EMailNew TEXT;

ALTER TABLE PluginInfo ADD COLUMN Cfg TEXT;

ALTER TABLE ApplicationFrameworkSettings DROP COLUMN MaxTaskTime;
ALTER TABLE ApplicationFrameworkSettings ADD COLUMN MaxExecTime INT DEFAULT 300;
CREATE TABLE IF NOT EXISTS RunningTasks (
    TaskId      INT,
    Callback    MEDIUMTEXT,
    Parameters  MEDIUMTEXT,
    Priority    INT,
    Description TEXT,
    StartedAt   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CrashInfo   TEXT,
    INDEX       (TaskId),
    INDEX       (Callback(64), Parameters(256))
);
ALTER TABLE TaskQueue ADD INDEX (Callback(64), Parameters(256));
ALTER TABLE TaskQueue MODIFY Callback MEDIUMTEXT;
ALTER TABLE TaskQueue MODIFY Parameters MEDIUMTEXT;

CREATE TABLE IF NOT EXISTS ResourceCounts (
    FieldId INT,
    ClassName TEXT,
    CountType TEXT,
    Count INT
);

INSERT INTO ResourceCounts (FieldId, ClassName, CountType, Count)
  VALUES (-1, '__LAST_UPDATED__', '',0);
