<?PHP

/**
 * Get the value of a metadata field for a resource. The value might be modified
 * by one or more plugins.
 * @param $Resource Resource object
 * @param $Field MetadataField object
 * @return the value of a metadata field for a resource
 */
function GetResourceFieldValue(Resource $Resource, MetadataField $Field=NULL)
{
    global $AF;

    # invalid field
    if (is_null($Field) || $Field->Status() !== MetadataSchema::MDFSTAT_OK)
    {
        return NULL;
    }

    $Value = $Resource->Get($Field, TRUE);

    if (is_string($Value))
    {
        $Value = stripslashes($Value);
    }

    # allow plugins to modify the value
    $SignalResult = $AF->SignalEvent(
        "EVENT_FIELD_DISPLAY_FILTER", array(
            "Field" => $Field,
            "Resource" => $Resource,
            "Value" => $Value));
    $Value = $SignalResult["Value"];

    return $Value;
}
