
CREATE TABLE IF NOT EXISTS ApplicationFrameworkSettings (
    MaxExecTime                     INT DEFAULT 300,
    MaxTasksRunning                 INT DEFAULT 2,
    LastTaskRunAt                   DATETIME,
    TemplateLocationCache           TEXT,
    TemplateLocationCacheExpiration DATETIME,
    TemplateLocationCacheInterval   INT DEFAULT 15
);

CREATE TABLE IF NOT EXISTS TaskQueue (
    TaskId      INT NOT NULL AUTO_INCREMENT,
    Callback    MEDIUMTEXT,
    Parameters  MEDIUMTEXT,
    Priority    INT,
    Description TEXT,
    INDEX       (TaskId),
    INDEX       (Callback(64), Parameters(256))
);

-- (RunningTasks table must match TaskQueue table except for StartedAt and CrashInfo)
CREATE TABLE IF NOT EXISTS RunningTasks (
    TaskId      INT,
    Callback    MEDIUMTEXT,
    Parameters  MEDIUMTEXT,
    Priority    INT,
    Description TEXT,
    StartedAt   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CrashInfo   TEXT,
    INDEX       (TaskId),
    INDEX       (Callback(64), Parameters(256))
);

CREATE TABLE IF NOT EXISTS PeriodicEvents (
    Signature   TEXT,
    LastRunAt   DATETIME
);

