<?PHP
#
#   FILE:  SPT--FileName.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("");

require_once("include/SPT--MetadataSchema.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function ListFields(&$Schema)
{
    $Fields = $Schema->GetFields();
    foreach ($Fields as $Field)
    {
        printf("Id: %d<br>\n", $Field->Id());
        printf("Name: %s<br>\n", $Field->Name());
        printf("Type: %s<br>\n", $Field->Type());
    }
}

function UnitTest()
{
	print("<br>Creating schema...<br>");
	$Schema = new MetadataSchema();
   
	print("<br>Listing fields...<br>");
    ListFields($Schema);
   
    print("<br>Adding field...<br>");
    $Schema->AddField("TestFieldOne", MetadataSchema::MDFTYPE_NUMBER);
    $Schema->AddField("TestFieldTwo", MetadataSchema::MDFTYPE_PARAGRAPH);
   
    print("<br>Listing fields...<br>");
    ListFields($Schema);
   
    print("<br>Dropping field...<br>");
    $Field = $Schema->GetFieldByName("TestFieldOne");
    $Schema->DropField($Field->Id());
    $Field = $Schema->GetFieldByName("TestFieldTwo");
    $Schema->DropField($Field->Id());
   
    print("<br>Listing fields...<br>");
    ListFields($Schema);
}


# ----- MAIN -----------------------------------------------------------------

include(FindUIFile("include/SPT--StandardPageStart.html"));
UnitTest();
include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
