<?PHP

#
#   FILE:  SPTUserFactory.php
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

class SPTUserFactory extends UserFactory
{

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
     * Object constructor
     */
    public function __construct()
    {
        global $Session;

        # create database handle for parent and local use
        $this->DB = new SPTDatabase();

        # call parent constructor with the global or our own session
        parent::__construct((isset($Session)) ? $Session : new Session($this->DB));
    }

    /**
     * Get the users sorted by how many resources they have added or edited,
     * starting with those who have added/edited the most. By default, the number
     * of users returned is five.
     * @param $Limit the maximum number of users to return
     */
    public function GetTopContributors($Limit = 5)
    {
        # assume no users will be found
        $Users = array();

        # fetch the top contributors
        $this->DB->Query("SELECT U.*"
                ." FROM APUsers U, Resources R"
                ." WHERE U.UserId = R.LastModifiedById"
                ." GROUP BY R.LastModifiedById"
                ." ORDER BY COUNT(*) DESC"
                ." LIMIT ".intval($Limit));
        $UserIds = $this->DB->FetchColumn("UserId");

        # for each user id found
        foreach ($UserIds as $UserId)
        {
            $Users[$UserId] = new SPTUser($UserId);
        }

        # return the newest users
        return $Users;
    }

    /**
     * Get the users sorted by when they last added or edited a resource
     * starting with those who added/edited a resource most recently. By default,
     * the number of users returned is five.
     * @param $Limit the maximum number of users to return
     */
    public function GetMostRecentContributors($Limit = 5)
    {
        # assume no users will be found
        $Users = array();

        # fetch the top contributors
        $this->DB->Query("SELECT U.*"
                ." FROM APUsers U, Resources R"
                ." WHERE U.UserId = R.LastModifiedById"
                ." GROUP BY U.UserId"
                ." ORDER BY MAX(R.DateLastModified) DESC"
                ." LIMIT ".intval($Limit));
        $UserIds = $this->DB->FetchColumn("UserId");

        # for each user id found
        foreach ($UserIds as $UserId)
        {
            $Users[$UserId] = new SPTUser($UserId);
        }

        # return the newest users
        return $Users;
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

}

?>
