<?php

class SystemConfiguration {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function SystemConfiguration($DB = NULL)
    {
        $this->DB = new Database();
    }

    # data access methods
    function TopLinkString($NewValue = DB_NOVALUE){  return $this->UpdateValue("TopLinkString", $NewValue);  }
    function TopLinkBeginLetter($NewValue = DB_NOVALUE) {  return $this->UpdateValue("TopLinkBeginLetter", $NewValue);  }
    function TopLinkEndLetter($NewValue = DB_NOVALUE) {  return $this->UpdateValue("TopLinkEndLetter", $NewValue);  }
    function AdminEmail($NewValue = DB_NOVALUE) {  return $this->UpdateValue("AdminEmail", $NewValue);  }
    function PasswordMailSubject($NewValue = DB_NOVALUE) {  return $this->UpdateValue("PasswordMailSubject", $NewValue);  }
    function PasswordMailBody($NewValue = DB_NOVALUE) {  return $this->UpdateValue("PasswordMailBody", $NewValue);  }
    function PasswordResetMailSubject($NewValue = DB_NOVALUE) {  return $this->UpdateValue("PasswordResetMailSubject", $NewValue);  }
    function PasswordResetMailBody($NewValue = DB_NOVALUE) {  return $this->UpdateValue("PasswordResetMailBody", $NewValue);  }
    function MailChangeMailSubject($NewValue = DB_NOVALUE) { return $this->UpdateValue("MailChangeMailSubject", $NewValue); }
    function MailChangeMailBody($NewValue = DB_NOVALUE) { return $this->UpdateValue("MailChangeMailBody", $NewValue); }
    function PortalName($NewValue = DB_NOVALUE) {  return $this->UpdateValue("PortalName", $NewValue);  }
    function DefaultActiveUI($NewValue = DB_NOVALUE) {  return $this->UpdateValue("DefaultActiveUI", $NewValue);  }
    function CurrentTheme($NewValue = DB_NOVALUE) {  return $this->UpdateValue("CurrentTheme", $NewValue);  }
    function DefaultCharacterSet($NewValue = DB_NOVALUE) {  return $this->UpdateValue("DefaultCharacterSet", $NewValue);  }
    function SearchTermsRequired($NewValue = DB_NOVALUE) {  return $this->UpdateValue("SearchTermsRequired", $NewValue);  }
    function AnnouncementsEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("AnnouncementsEnabled", $NewValue);  }
    function ForumsEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ForumsEnabled", $NewValue);  }
    function AllowMultipleUIsEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("AllowMultipleUIsEnabled", $NewValue);  }
    function ResourceLaunchesNewWindowEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ResourceLaunchesNewWindowEnabled", $NewValue);  }
    function UserAgentsEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("UserAgentsEnabled", $NewValue);  }
    function ResourceRatingsEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ResourceRatingsEnabled", $NewValue);  }
    function ResourceCommentsEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ResourceCommentsEnabled", $NewValue);  }
    function AccessibilityWizardEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("AccessibilityWizardEnabled", $NewValue);  }
    function ReleaseFlagApproved($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ReleaseFlagApproved", $NewValue);  }
    function SearchDBEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("SearchDBEnabled", $NewValue);  }
    function RecommenderDBEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("RecommenderDBEnabled", $NewValue);  }
    function OAISQEnabled($NewValue = DB_NOVALUE) {  return $this->UpdateValue("OAISQEnabled", $NewValue);  }
    function NumAnnounceOnHomePage($NewValue = DB_NOVALUE) {  return $this->UpdateValue("NumAnnounceOnHomePage", $NewValue);  }
    function NumResourcesOnHomePage($NewValue = DB_NOVALUE) {  return $this->UpdateValue("NumResourcesOnHomePage", $NewValue);  }
    function LegalNotice($NewValue = DB_NOVALUE) {  return $this->UpdateValue("LegalNotice", $NewValue);  }
    function DefaultRecordsPerPage($NewValue = DB_NOVALUE) {  return $this->UpdateValue("DefaultRecordsPerPage", $NewValue);  }
    function NumClassesPerBrowsePage($NewValue = DB_NOVALUE)
    {
        # if new classes per browse page has been specified
        if ($NewValue !== DB_NOVALUE &&
            $NewValue != $this->UpdateValue("NumClassesPerBrowsePage",DB_NOVALUE))
        {
            # clear all classification links
            $this->TopLinkString("");
            $this->DB->Query("UPDATE Classifications SET LinkString=''");
        }
        return $this->UpdateValue("NumClassesPerBrowsePage", $NewValue);
    }
    function NumColumnsPerBrowsePage($NewValue = DB_NOVALUE) {  return $this->UpdateValue("NumColumnsPerBrowsePage", $NewValue);  }
    function BrowsingFieldId($NewValue = DB_NOVALUE) {  return $this->UpdateValue("BrowsingFieldId", $NewValue);  }
    function OaiIdDomain($NewValue = DB_NOVALUE) {  return $this->UpdateValue("OaiIdDomain", $NewValue);  }
    function OaiIdPrefix($NewValue = DB_NOVALUE) {  return $this->UpdateValue("OaiIdPrefix", $NewValue);  }
    function OaiEarliestDate($NewValue = DB_NOVALUE) {  return $this->UpdateValue("OaiEarliestDate", $NewValue);  }
    function OaiDateGranularity($NewValue = DB_NOVALUE) {  return $this->UpdateValue("OaiDateGranularity", $NewValue);  }
    function SiteKeywords($NewValue = DB_NOVALUE) { return $this->UpdateValue("SiteKeywords", $NewValue); }
    function AboutText($NewValue = DB_NOVALUE) { return $this->UpdateValue("AboutText", $NewValue); }

    function ContactName($NewValue = DB_NOVALUE) { return $this->UpdateValue("ContactName", $NewValue); }
    function ContactEmail($NewValue = DB_NOVALUE) { return $this->UpdateValue("ContactEmail", $NewValue); }
    function Organization($NewValue = DB_NOVALUE) { return $this->UpdateValue("Organization", $NewValue); }
    function OrganizationType($NewValue = DB_NOVALUE) { return $this->UpdateValue("OrganizationType", $NewValue); }
    function SiteType($NewValue = DB_NOVALUE) { return $this->UpdateValue("SiteType", $NewValue); }
    function OkayToListSite($NewValue = DB_NOVALUE) { return $this->UpdateValue("OkayToListSite", $NewValue); }
    function LastRegisteredOn($NewValue = DB_NOVALUE) { return $this->UpdateValue("LastRegisteredOn", $NewValue); }
    function AddAWStatsScript($NewValue = DB_NOVALUE) { return $this->UpdateValue("AddAWStatsScript", $NewValue); }
    function AddGoogleAnalytics($NewValue = DB_NOVALUE) { return $this->UpdateValue("AddGoogleAnalytics", $NewValue); }
    function GoogleAnalyticsCode($NewValue = DB_NOVALUE) { return $this->UpdateValue("GoogleAnalyticsCode", $NewValue); }
    function DisplayLimitsByDefault($NewValue = DB_NOVALUE) { return $this->UpdateValue("DisplayLimitsByDefault", $NewValue); }
    function DefaultSortField($NewValue = DB_NOVALUE) { return $this->UpdateValue("DefaultSortField", $NewValue); }

    function LogoFileName() {  return $this->UpdateValue("LogoFileName",DB_NOVALUE, "UIStyleConfiguration");  }
    function LogoAltText() {  return $this->UpdateValue("LogoAltText",DB_NOVALUE, "UIStyleConfiguration");  }
    function LogoWidth() {  return $this->UpdateValue("LogoWidth",DB_NOVALUE,"UIStyleConfiguration");  }
    function LogoHeight() {  return $this->UpdateValue("LogoHeight",DB_NOVALUE,"UIStyleCOnfiguration");  }

    function HasRegistered() {  return strlen($this->UpdateValue("LastRegisteredOn",DB_NOVALUE)) ? TRUE : FALSE;  }

    function TitleField($NewValue = DB_NOVALUE) { return $this->UpdateValue("TitleField", $NewValue); }
    function DescriptionField($NewValue = DB_NOVALUE) { return $this->UpdateValue("DescriptionField", $NewValue); }
    function UrlField($NewValue = DB_NOVALUE) { return $this->UpdateValue("UrlField", $NewValue); }
    function ScreenshotField($NewValue = DB_NOVALUE) { return $this->UpdateValue("ScreenshotField", $NewValue); }

    function SecureLogin($NewValue = DB_NOVALUE) { return $this->UpdateValue("SecureLogin", $NewValue); }

    function DefaultUserPrivs($NewValue = DB_NOVALUE)
    {
        if ($NewValue !== DB_NOVALUE)
        {
            $NewValue = serialize($NewValue);
        }

        $Result = unserialize($this->UpdateValue("DefaultUserPrivs", $NewValue));

        if (!is_array($Result))
        {
            $Result = $this->DefaultUserPrivs(array());
        }

        return $Result;
    }

    function Value($FieldName, $NewValue = DB_NOVALUE)
            {  return $this->UpdateValue($FieldName, $NewValue);  }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $DB;
    private $DBFields;
    private function UpdateValue($FieldName, $NewValue, $Table="SystemConfiguration")
    {
        return $this->DB->UpdateValue($Table, $FieldName,
                                      $NewValue, NULL, $this->DBFields);
    }
}
