<?PHP
#
#   FILE:  AddNewControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       PrintAddedControlledNames()
#           - displays added controlled names and variants
#
#   FUNCTIONS EXPECTED:
#           - none
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintAddedControlledName()
{
    $F_ControlledName = $_POST["F_ControlledName"];
    $F_Variant = $_POST["F_Variant"];

    print $F_ControlledName;
    if (!empty($F_Variant))
        print ", Variant (".$F_Variant.")";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function AddControlledName()
{
    global $Session;
    global $DisplayString;
    global $AddedNames;
    global $Variants;
    global $Submit;

    $DB = new SPTDatabase();
    $Schema = new MetadataSchema();

    $F_ControlledName = $_POST["F_ControlledName"];
    $F_FieldId = $_POST["F_FieldId"];
    $F_Variant = $_POST["F_Variant"];
    if ( isset($_POST["F_Qualifier"]) )
        $F_Qualifier = $_POST["F_Qualifier"];

    # set "--" to NULL
    if (!isset($F_Qualifier) || is_null($F_Qualifier) || $F_Qualifier == "--")
        $F_Qualifier = "NULL";

    if ((is_null($F_ControlledName) || empty($F_ControlledName)))
    {
        $Session->PassVariable("ErrorMessage",
            "Error: Controlled Name is a required field.");
        global $AF;
        $AF->SetJumpToPage("AddControlledName");
    }
    else
    {
        if (!empty($F_ControlledName))
        {
            # check to see if it already exists
            $CN = new ControlledName(NULL, $F_ControlledName,
                    $F_FieldId, $F_Qualifier, $F_Variant);

            # controlled name found, error
            if ($CN->Status() == ControlledName::STATUS_EXISTS)
            {
                $Session->PassVariable("ErrorMessage",
                    "Error: Controlled Name '".$F_ControlledName.
                    "' already exists.");
                global $AF;
                $AF->SetJumpToPage("AddControlledName");
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $DisplayString;
global $Submit;
global $Variants;

if (!CheckAuthorization(PRIV_NAMEADMIN)) {  return;  }

# get and pass through default type id
$F_FieldId = $Session->Get("F_FieldId");
$Session->PassVariable("F_FieldId", $F_FieldId);

if (isset($Submit) && substr($Submit, 0, 7) == "Add New")
    AddControlledName();
else
{
    $F_Variant = $_POST["F_Variant"];
    $F_ControlledName = $_POST["F_ControlledName"];
    $F_FieldId = $_POST["F_FieldId"];
    $Session->PassVariable("F_Variant", $F_Variant);
    $Session->PassVariable("F_ControlledName", $F_ControlledName);
    $Session->PassVariable("F_FieldId", $F_FieldId);
    $AF->SetJumpToPage("AddControlledName");
}

PageTitle("Add Controlled Name Complete");