<?PHP
#
#   FILE:  AddResourceComment.php
#
#   FUNCTIONS PROVIDED:
#       IsEditing
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function IsEditing()
{
    global $Message, $User;
    return isset($Message) && ($User->Id() == $Message->PosterId()
           || $User->HasPriv(PRIV_SYSADMIN));
}

function GetBody()
{
    global $Message, $Session;

    if (!isset($Message) && !$Session->IsRegistered("F_Body"))
    {
        return "";
    }

    if (!isset($Message) && $Session->IsRegistered("F_Body"))
    {
        return defaulthtmlentities($Session->Get("F_Body"));
    }

    return defaulthtmlentities($Message->Body());
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintTitle()
{
    global $User, $Resource;

    $TitleField = $Schema->GetFieldByMappedName("Title");
    if ($Resource->UserCanViewField($User, $TitleField))
    {
        print strip_tags($Resource->Get($TitleField),
            "<b><i><u><sub><sup><strike><a>");
    }
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintSubject()
{
    global $Message;

    print defaulthtmlentities($Message->Subject());
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintBody()
{
    global $Message;

    print defaulthtmlentities($Message->Body());
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintErrorMessages() { }

/**
 * THIS FUNCTION IS DEPRECATED
 */
function CheckForEdit()
{
    global $Message, $User;

    return isset($Message) && ($User->Id() == $Message->PosterId()
                                 || $User->HasPriv(PRIV_SYSADMIN));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

global $Message;
global $Resource;
global $TitleField;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_POSTCOMMENTS)) {  return;  }

$Schema = new MetadataSchema();
$TitleField = $Schema->GetFieldByMappedName("Title");

# do the query for this resource
if (isset($_GET["ResourceId"]))
{
    $Resource = new Resource($_GET["ResourceId"]);
}
else if ($Session->IsRegistered("ResourceId"))
{
    $Resource = new Resource($Session->Get("ResourceId"));
}

if (!isset($Resource) || $Resource->Status() != 1)
{
    $AF->SetJumpToPage("Home");
    return;
}

if (isset($_GET["MessageId"]))
{
    $Message = new Message($_GET["MessageId"]);
}

else if ($Session->IsRegistered("MessageId"))
{
    $Message = new Message($Session->Get("MessageId"));
}

if (IsEditing())
{
    PageTitle("Update Resource Comment");
}

# or adding
else
{
    PageTitle("Add Resource Comment");
}

# pass along necessary variables
$Session->PassVariable("ResourceId", $Resource->Id());
$Session->PassVariable("ParentId", $Resource->Id());

if (isset($Message))
{
    $Session->PassVariable("F_Subject", $Message->Subject());
    $Session->PassVariable("MessageId", $Message->MessageId());
}

else
{
    $Session->PassVariable("F_Subject", "Comment On: ".$Resource->GetMapped("Title"));
}
