<?PHP
#
#   FILE:  EditOptionList.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/
#

PageTitle("Edit Option List");
if (!CheckAuthorization(PRIV_NAMEADMIN)) {  return;  }


# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# retrieve field if specified
$Schema = new MetadataSchema();
if (isset($_GET["FI"]) || isset($_POST["F_FieldId"]))
{
    $FieldId = intval(isset($_GET["FI"]) ? $_GET["FI"] : $_POST["F_FieldId"]);
    $Field = $Schema->GetField($FieldId);
    if ($Field && ($Field->Type() == MetadataSchema::MDFTYPE_OPTION))
    {
        $G_Field = $Field;
        $G_OptionNames = $G_Field->GetPossibleValues();
        $G_Options = array();
        foreach ($G_OptionNames as $Id => $Name)
        {
            $G_Options[$Id] = new ControlledName($Id);
        }
    }
}

# if form submitted
if (isset($_POST["F_Submit"]))
{
    # start action message block
    $G_Msgs[] = "For the <i>".$G_Field->GetDisplayName()."</i> option list:";

    # if user requested that changes be saved
    if ($_POST["F_Submit"] == "Save Changes")
    {
        # while there are field values to process
        $Index = 0;
        while (isset($_POST["F_OptionId".$Index]))
        {
            # save edited value
            $Id = $_POST["F_OptionId".$Index];
            if ($_POST["F_Option".$Index] != $G_Options[$Id]->Name())
            {
                $OldName = $G_Options[$Id]->Name();
                $NewName = $_POST["F_Option".$Index];
                $G_Options[$Id]->Name($NewName);
                $G_Msgs[] = "option <i>".$OldName."</i> changed to <i>".$NewName."</i>";
            }

            # if change requested and value selected
            if (isset($_POST["F_ConfirmRemap"])
                    && ($_POST["F_ConfirmRemap"] == $Id)
                    && ($_POST["F_RemapTo".$Index] != -1))
            {
                # change all usage of this option to specified option
                $G_Msgs[] = "associations for option <i>".$G_Options[$Id]->Name()
                        ."</i> remapped to <i>"
                        .$G_Options[$_POST["F_RemapTo".$Index]]->Name()."</i>";
                $G_Options[$Id]->RemapTo($_POST["F_RemapTo".$Index]);
            }
            # else if deletion requested
            elseif (isset($_POST["F_ConfirmDelete".$Index]))
            {
                $G_Msgs[] = "option <i>".$G_Options[$Id]->Name()."</i> deleted";
                $G_Options[$Id]->Delete(TRUE);
            }

            # move to next field
            $Index++;
        }

        # save new default setting
        $DefaultValue = GetArrayValue($_POST, "F_Default");
        if ($DefaultValue == -1) {  $DefaultValue = NULL;  }
        if ($DefaultValue != $G_Field->DefaultValue())
        {
            $G_Field->DefaultValue($DefaultValue);

            if ($G_Field->Type() == MetadataSchema::MDFTYPE_OPTION
                && is_array($DefaultValue) && count($DefaultValue))
            {
                $Message = "default value changed to ";
                $Count = 0;

                foreach ($DefaultValue as $Value)
                {
                    $Name = defaulthtmlentities($G_Options[$Value]->Name());
                    $Message .= "<i>".$Name."</i>";

                    $Count++;

                    if ($Count < count($DefaultValue))
                    {
                        $Message .= ", ";
                    }
                }

                $G_Msgs[] = $Message;
            }

            else
            {
                $G_Msgs[] = "default value "
                        .(($DefaultValue == NULL) ? "cleared"
                        : "changed to <i>"
                                .$G_Options[$DefaultValue]->Name()."</i>");
            }
        }

        # if new value supplied
        if (isset($_POST["F_ConfirmAdd"]) && strlen(trim($_POST["F_AddName"])))
        {
            # add new value
            $NewQualifierId = (isset($_POST["F_AddQualifier"])
                    && ($_POST["F_AddQualifier"] >= 0)) ? $_POST["F_AddQualifier"]
                    : "NULL";
            $NewName = new ControlledName(NULL, trim($_POST["F_AddName"]),
                    $G_Field->Id(), $NewQualifierId);
            $G_Msgs[] = "new option <i>".$_POST["F_AddName"]."</i> added";
        }

        # reload options
        $G_OptionNames = $G_Field->GetPossibleValues();
        $G_Options = array();
        foreach ($G_OptionNames as $Id => $Name)
        {
            $G_Options[$Id] = new ControlledName($Id);
        }

        if (count($G_Msgs) == 1)
        {
            $G_Msgs[] = "no changes made";
        }
        else
        {
            $RFactory = new ResourceFactory();
            $RFactory->QueueResourceCountUpdate();
        }
    }
    else
    {
        $G_Msgs[] = "editing cancelled and any changes discarded";
    }

    # unset field so that list of possible fields is brought up again
    unset($G_Field);
}

# if no valid field specified
if (!isset($G_Field))
{
    # load list of possible fields
    $G_OptionFields = $Schema->GetFields(MetadataSchema::MDFTYPE_OPTION,
                                         MetadataSchema::MDFORDER_EDITING);
}
