<?PHP
#
#   FILE:  Forums.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print forum name
function PrintForumName()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->ForumName();
    }
}

# print forum description
function PrintForumDescription()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->ForumDescription();
    }
}

# print forum moderator email
function PrintForumModeratorEmail()
{
    global $ForumId, $User;
    if (isset($ForumId) && $User->IsLoggedIn() )
    {
        $Forum = new Forum($ForumId);
        $ModeratorEmail = $Forum->ModeratorEmail();

        if (!is_null($ModeratorEmail))
        {
            print "(" . MungeEmailAddress($ModeratorEmail) . ")";
        }
    }
}

# print forum moderator
function PrintForumModerator()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->ModeratorName();
    }
}

# print forumid
function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

# print topic count
function PrintTopicCount()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->TopicCount();
    }
}

# print message count
function PrintMessageCount()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->MessageCount();
    }
}

# print last message date
function PrintLastMessageDate()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->LastMessageDate();
    }
}

# print last message poster
function PrintLastMessagePoster()
{
    global $ForumId;

    if (isset($ForumId))
    {
        $Forum = new Forum($ForumId);
        print $Forum->LastMessagePoster();
    }
}

# print last message poster email
function PrintLastMessagePosterEmail()
{
    global $ForumId, $User;

    if (isset($ForumId) && $User->IsLoggedIn() )
    {
        $Forum = new Forum($ForumId);
        $LastPosterEmail = $Forum->LastMessagePosterEmail();

        if (!is_null($LastPosterEmail))
        {
            print "(" . MungeEmailAddress($LastPosterEmail) . ")";
        }
    }
}

function DisplayForums()
{
    global $ForumId;

    $Query = "Select * from Forums Order By ForumName";
    $DB = new SPTDatabase();
    $DB->Query($Query);

    while ($Entry = $DB->FetchRow())
    {
        $ForumId = $Entry["ForumId"];

        # print forum info
        PrintForum();
    }
}

function GetForumCount()
{
    $DB = new SPTDatabase();

    $Count = $DB->Query("SELECT COUNT(*) AS Count FROM Forums", "Count");
    $Count = intval($Count);

    return $Count;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ForumId;

PageTitle("Discussion Forums");
