<?PHP
#
#   FILE:  PopulateField.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout Project
#   http://scout.wisc.edu/
#

PageTitle("Populate Metadata Field");

# ----- CONFIGURATION  -------------------------------------------------------

# location of vocabulary (.voc) files
$PathToVocabularyFiles = "data/Vocabularies/";


# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# check that user has permission for this
if (!CheckAuthorization(PRIV_COLLECTIONADMIN)) {  return;  }

# check to make sure we have at least PHP 5.x (for SimpleXML support)
if (PHP_VERSION < 5)
{
    $G_ErrorMessages[] = "PHP version 5.x or later is required for the <i>Populate Field</i> feature.  You currently have PHP version ".PHP_VERSION.".";
}
else
{
    # load metadata field
    if (isset($_GET["ID"]))
    {
        $Schema = new MetadataSchema();
        $G_Field = $Schema->GetField(intval($_GET["ID"]));
    }
    if (!isset($G_Field) || ($G_Field->Status() != MetadataSchema::MDFSTAT_OK))
    {
        $G_ErrorMessages[] = "Could not load metadata field.";
    }
    elseif (!($G_Field->Type() & (MetadataSchema::MDFTYPE_CONTROLLEDNAME|MetadataSchema::MDFTYPE_OPTION|MetadataSchema::MDFTYPE_TREE)))
    {
        $G_ErrorMessages[] = "The <i>".$G_Field->GetDisplayName()."</i> field is not one of the"
                ." types for which population is support.  Only <b>Controlled Name</b>,"
                ." <b>Option</b>, and <b>Tree</b> fields can be populated with"
                ." the prepackaged vocabularies.";
    }

    # if vocabulary specified
    if (isset($_GET["VH"]))
    {
        # load specified vocabulary
        $VocFact = new VocabularyFactory($PathToVocabularyFiles);
        $G_Vocabulary = $VocFact->GetVocabularyByHash($_GET["VH"]);
        if ($G_Vocabulary === NULL)
        {
            $G_ErrorMessages[] = "No vocabulary file found with specified hash.";
        }
        else
        {
            # if vocabulary import was confirmed
            if (isset($_GET["CP"]) && !isset($G_ErrorMessages))
            {
                # import specified vocabulary
                $G_IsVocabImport = TRUE;
                $Terms = $G_Vocabulary->TermList();
                $FactoryClass = ($G_Field->Type() == MetadataSchema::MDFTYPE_TREE)
                        ? "ClassificationFactory" : "ControlledNameFactory";
                $Factory = new $FactoryClass($G_Field->Id());

                # if new vocabulary has a qualifier
                if ($G_Vocabulary->HasQualifier())
                {
                    # if we already have a qualifier with the same name
                    $QualFact = new QualifierFactory();
                    if ($QualFact->QualifierNameIsInUse($G_Vocabulary->QualifierName()))
                    {
                        # if details for existing and new qualifier do not match
                        $Qualifier = $QualFact->GetQualifierByName(
                                $G_Vocabulary->QualifierName());
                        if ($G_Vocabulary->QualifierNamespace() != $Qualifier->NSpace()
                                || ($G_Vocabulary->QualifierUrl() != $Qualifier->Url()))
                        {
                            # error out
                            $G_ErrorMessages[] = "The vocabulary <i>".$G_Vocabulary->Name()
                                    ."</i> specifies a qualifier <i>"
                                    .$G_Vocabulary->QualifierName()."</i> that conflicts"
                                    ." with an existing qualifier (has the same name but"
                                    ." a different namespace or URL or both).";
                        }
                        else
                        {
                            # add new vocabulary with qualifier
                            $G_AddedItemCount = $Factory->AddItems($Terms, $Qualifier);
                            $G_Field->AssociateWithQualifier($Qualifier);
                        }
                    }
                    else
                    {
                        # add new vocabulary with qualifier
                        $Qualifier = new Qualifier();
                        $Qualifier->Name($G_Vocabulary->QualifierName());
                        $Qualifier->NSpace($G_Vocabulary->QualifierNamespace());
                        $Qualifier->Url($G_Vocabulary->QualifierUrl());
                        $G_AddedItemCount = $Factory->AddItems($Terms, $Qualifier);
                        $G_Field->AssociateWithQualifier($Qualifier);
                    }
                }
                else
                {
                    # add new vocabulary
                    $G_AddedItemCount = $Factory->AddItems($Terms);
                }
            }
            else
            {
                # set flag to indicate preview/confirm
                $G_IsVocabPreview = TRUE;
            }
        }
    }
    else
    {
        # load available vocabularies
        $VocFact = new VocabularyFactory($PathToVocabularyFiles);
        $G_Vocabularies = $VocFact->GetVocabularies();
        if (count($G_Vocabularies) == 0)
        {
            $G_ErrorMessages[] = "No vocabulary files found in <i>"
                    .$PathToVocabularyFiles."</i>.";
        }
    }
}
