<?PHP
#
#   FILE:  PreviewComment.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

PageTitle("Preview Comment");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintSubmitButton()
{
    global $IsUpdate;

    print ($IsUpdate ? "Update Message" : "Post New Comment");
}

function PrintSubject()
{
    global $F_Subject;

    print defaulthtmlentities(stripslashes($F_Subject));
}

function PrintBody()
{
    global $F_Body;

    print nl2br(defaulthtmlentities(stripslashes($F_Body)));
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintHeading()
{
    print "Preview Comment";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_Body;
global $F_Subject;

$ResourceId = $Session->Get("ResourceId");
$ParentId = $Session->Get("ParentId");
$F_Subject = $Session->Get("F_Subject");
$F_Body = $Session->Get("F_Body");
$IsUpdate = $Session->Get("IsUpdate");

if (isset($_POST["ForumId"]))
{
    $ForumId = intval($_POST["ForumId"]);
}
elseif (isset($_GET["ForumId"]))
{
    $ForumId = intval($_GET["ForumId"]);
}
else
{
    $ForumId = $Session->Get("ForumId");
}

# pass along variables for processing
$Session->PassVariable("ResourceId", $ResourceId);
$Session->PassVariable("ParentId", $ParentId);
$Session->PassVariable("F_Subject", $F_Subject);
$Session->PassVariable("F_Body", $F_Body);
$Session->PassVariable("IsUpdate",$IsUpdate);

if (isset($ForumId))
{
    $Session->PassVariable("ForumId", $ForumId);
}

if ($IsUpdate)
{
    $MessageId = $Session->Get("MessageId");
    $Session->PassVariable("MessageId", $MessageId);
}
