<?PHP

abstract class AddThis_Config
{

    /**
     * Generate and return the Javascript representation of the configuration.
     * @return the Javascript representation of the configuration
     */
    public function GetJavascript()
    {
        $VarName = $this->VarName;

        $Javascript =  "<script type=\"text/javascript\">var ".$VarName." = ";

        $Properties = get_object_vars($this);
        $JsonProperties = array();

        # remove VarName since it's an internal variable
        unset($Properties["VarName"]);

        foreach ($Properties as $Name => $Value)
        {
            if (is_null($Value))
            {
                continue;
            }

            $JsonName = $this->TransformName($Name);

            $JsonProperties[$JsonName] = $Value;
        }

        $Javascript .= json_encode($JsonProperties);
        $Javascript .= "</script>";

        return $Javascript;
    }

    /**
     * Generate and print the Javascript representation of the configuration.
     */
    public function PrintJavascript()
    {
        print $this->GetJavascript();
    }

    /**
     * Transform a PHP variable name to an AddThis Javascript one
     * @param $Name PHP variable name
     * @return an AddThis Javascript variable name
     */
    protected function TransformName($Name)
    {
        $PhaseOne = preg_replace('/([a-z])([A-Z])/', "\\1_\\2", $Name);
        $PhaseTwo = strtolower($PhaseOne);

        return $PhaseTwo;
    }

    /**
     * @var $VarName AddThis Javascript variable name
     */
    protected $VarName;

}
