<?PHP
#
#   FILE:  BatchEdit.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function Rules_GetRuleList()
{
    global $G_PluginManager;

    $List = array();
    $RulesPlugin = $G_PluginManager->GetPlugin("Rules");
    $Rules = $RulesPlugin->GetRules();

    foreach ($_POST as $Key => $Value)
    {
        # if the variable matches what is expected when a rule is selected
        if (@preg_match('/F_Selected_([0-9]+)/', $Key, $Matches))
        {
            $RuleId = $Matches[1];
            $Rule = GetArrayValue($Rules, $RuleId);

            # if the rule ID is actually valid and a rule exists
            if (!is_null($Rule))
            {
                $List[$RuleId] = $Rule;
            }
        }
    }

    return $List;
}

# ----- MAIN -----------------------------------------------------------------

# check that user should be on this page
CheckAuthorization(PRIV_COLLECTIONADMIN, PRIV_SYSADMIN);

$AF->SuppressHTMLOutput();

$RulesPlugin = $G_PluginManager->GetPlugin("Rules");
$Rules = Rules_GetRuleList();
$Action = GetArrayValue($_POST, "F_SelectionAction");

# enable/disable rules
if ($Action == "enable" || $Action == "disable")
{
    $Enabled = $Action == "enable" ? 1 : 0;

    foreach ($Rules as $RuleId => $Rule)
    {
        $Rule["Enabled"] = $Enabled;
        $RulesPlugin->UpdateRule($Rule);
    }
}

# remove rules
else if ($Action == "remove")
{
    foreach ($Rules as $RuleId => $Rule)
    {
        $RulesPlugin->DeleteRule($RuleId);
    }
}

$AF->SetJumpToPage("P_Rules_List");
