<?PHP
#
#   FILE:  List.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function Rules_PrintRules()
{
    global $G_Rules;

    foreach ($G_Rules as $Rule)
    {
        Rules_PrintRule($Rule);
    }
}

function Rules_GetRuleOperators()
{
    return array(
        1 => "has changed",
        2 => "equals",
        3 => "does not equal",
        4 => "is less than",
        5 => "is greater than",
        6 => "is less than or equal to",
        7 => "is greater than or equal to",
        8 => "is set to true",
        9 => "is set to false",
        10 => "is changed to",
        11 => "is changed to",
        12 => "is changed to user with privilege",
        13 => "file added");
}

function Rules_PrintRuleValue($Rule)
{
    global $G_Schema;

    $Field = $G_Schema->GetField($Rule["Conditions"]["FieldId"]);
    $Type = $Field->Type();

    switch ($Type)
    {
        case MetadataSchema::MDFTYPE_NUMBER:
            Rules_PrintNumericRuleValue($Rule);
            break;

        case MetadataSchema::MDFTYPE_DATE:
        case MetadataSchema::MDFTYPE_TIMESTAMP:
            Rules_PrintDateRuleValue($Rule);
            break;

        case MetadataSchema::MDFTYPE_TREE:
        case MetadataSchema::MDFTYPE_CONTROLLEDNAME:
        case MetadataSchema::MDFTYPE_OPTION:
            Rules_PrintControlledRuleValue($Rule);
            break;

        case MetadataSchema::MDFTYPE_USER:
            Rules_PrintUserRuleValue($Rule);
            break;

        default:
            break;
    }
}

function Rules_GetRuleFieldName($Rule)
{
    global $G_Schema;

    $Field = $G_Schema->GetField($Rule["Conditions"]["FieldId"]);
    $Name = $Field->GetDisplayName();

    return $Name;
}

function Rules_PrintMetadataFieldOptionList($Name)
{
    global $G_Schema;

    $Fields = $G_Schema->GetFields();
    $FieldInfo = array();

    foreach ($Fields as $Field)
    {
        # use the display name as the key so that it's easily sorted
        # alphabetically
        $FieldInfo[$Field->GetDisplayName()] = array(
            "Value" => defaulthtmlentities($Field->Id()),
            "Label" => defaulthtmlentities($Field->GetDisplayName()));
    }

    # sort alphabetically
    ksort($FieldInfo);

    $Name = defaulthtmlentities($Name);

?>
  <select id="<?PHP print $Name; ?>" name="<?PHP print $Name; ?>">
    <?PHP foreach ($FieldInfo as $Info) { extract($Info); ?>
      <option value="<?PHP print $Value; ?>"><?PHP print $Label; ?></option>
    <?PHP } ?>
  </select>
<?PHP
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Rules List");

# check that user should be on this page
CheckAuthorization(PRIV_COLLECTIONADMIN, PRIV_SYSADMIN);

global $G_Schema;
global $G_RulesPlugin;
global $G_Rules;
global $G_AtLeastOneRule;

$G_Schema = new MetadataSchema();
$G_RulesPlugin = $G_PluginManager->GetPlugin("Rules");
$G_Rules = $G_RulesPlugin->GetRules();
$G_AtLeastOneRule = count($G_Rules) > 0;
