<?PHP

class UrlChecker_Resource extends Resource
{

    /**
     * Constructor: save the check date if given and pass the resource ID
     * parameter onto the parent class.
     * @param $ResourceId resource ID
     * @param $CheckDate the last time the resource was checked
     */
    public function __construct($ResourceId=NULL, $CheckDate=NULL)
    {
        if (!is_null($CheckDate))
        {
            $this->CheckDate = strval($CheckDate);
        }

        parent::Resource($ResourceId);
    }

    /**
     * Get the last time the resource was checked.
     * @return the last time the resource was checked, or "N/A" if never checked
     */
    public function GetCheckDate()
    {
        if (!isset($this->CheckDate))
        {
            $DB = new Database();
            $DB->Query("
                SELECT *
                FROM UrlChecker_ResourceHistory
                WHERE ResourceId = '".intval($this->Id())."'");

            if ($DB->NumRowsSelected())
            {
                $Row = $DB->FetchRow();
                $this->CheckDate = $Row["CheckDate"];
            }

            else
            {
                $this->CheckDate = "N/A";
            }
        }

        return $this->CheckDate;
    }

    /**
     * @var $CheckDate holds when the resource was checked last
     */
    private $CheckDate;

}
