<?PHP

class LatLongPoints extends Plugin {

    function Register()
    {
        $this->Name = "Latitude/Longitude Points";
        $this->Version = "1.0.0";
        $this->Description = "The Latitude/Longitude Points plugin makes any"
                ." Point metadata fields accept input and display in common"
                ." latitude/longitude format (e.g. <i>43&deg; 21' 10&quot; N</i>).";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array("CWISCore" => "2.0.0");
        $this->EnabledByDefault = FALSE;
    }

    function HookEvents()
    {
        return array(
                "EVENT_FIELD_DISPLAY_FILTER" => "LatLongDecimalToDegrees",
                "EVENT_PRE_FIELD_EDIT_FILTER" => "LatLongDecimalToDegrees",
                "EVENT_POST_FIELD_EDIT_FILTER" => "LatLongDegreesToDecimal",
                );
    }

    function LatLongDecimalToDegrees($Field, $Resource, $Value)
    {
        $ReturnValue = array(
                "Field" => $Field,
                "Resource" => $Resource,
                "Value" => $Value);
        if (($Field->Type() == MetadataSchema::MDFTYPE_POINT))
        {
            foreach (array("X", "Y") as $Axis)
            {
                if (floatval($Value[$Axis]))
                {
                    $Coord = $Value[$Axis];
                    $Degrees = floor(abs($Coord));
                    $Minutes = floor((abs($Coord) - $Degrees) * 60);
                    $Seconds = round((abs($Coord) 
                            - $Degrees - ($Minutes / 60)) * 3600);
                    $ReturnValue["Value"][$Axis] = 
                            $Degrees.html_entity_decode("&deg; ")
                            .$Minutes."' ".$Seconds."\" "
                            .(($Coord >= 0) ? (($Axis == "X") ? "N" : "E")
                            : (($Axis == "X") ? "S" : "W"));
                }
            }
        }
        return $ReturnValue;
    }

    function LatLongDegreesToDecimal($Field, $Resource, $Value)
    {
        $ReturnValue = array(
                "Field" => $Field,
                "Resource" => $Resource,
                "Value" => $Value);
        if (($Field->Type() == MetadataSchema::MDFTYPE_POINT))
        {
            # for each of the coordinate
            foreach (array("X", "Y") as $Axis)
            {
                # remove all extraneous characters
                $Value = strtoupper(trim($ReturnValue["Value"][$Axis]));
                $Value = preg_replace("/[^0-9SNEW.\s-]/", " ", $Value);

                # split up into individual components
                $Pieces = preg_split("/\s+/", $Value);

                # if components were found
                if (count($Pieces) && floatval($Pieces[0]))
                {
                    # calculate fractional value from remaining components
                    $NewValue = 0;
                    $Divisor = 1;
                    foreach ($Pieces as $Piece)
                    {
                        $NewValue += $Piece / $Divisor;
                        $Divisor *= 60;
                    }

                    # flip sign if direction indicates
                    if ((substr($Piece, -1) == "W") || (substr($Piece, -1) == "S"))
                    {
                        $NewValue = 0 - $NewValue;
                    }

                    # save new decimal value
                    $ReturnValue["Value"][$Axis] = $NewValue;
                }
            }
        }
        return $ReturnValue;
    }
}

?>
