<?php
#
#   FILE:  SPT--AssignClassification.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--ResourceFactory.php");

CheckAuthorization(PRIV_RESOURCEADMIN);

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process selected classifications
function ProcessSelectedClassifications()
{
    global $Session, $ResourceId, $HTTP_POST_VARS;

    $DB =& new SPTDatabase();
    $NewRecordFlag = 0;
    
    reset ($HTTP_POST_VARS);
    while (list($var, $value) = each ($HTTP_POST_VARS))
    {
        if(ereg("class_([0-9]+)",$var,$regs) )
        {
            trim($value);
            if($value != "")
            {
                $ClassName = $value;
                continue;
            }
        }
        if(ereg("classid_([0-9]+)",$var,$regs) )
        {
            trim($value);
            if($value != "")
            {
                $ClassId = $value; 
        
                $query = "SELECT ClassificationId FROM ResourceClassInts ".
                    "WHERE ResourceId = $ResourceId AND ClassificationId ".
                    "= $ClassId";

                $DB->Query($query);
                if($DB->NumRowsSelected() == 0)
                {
                    $query = "INSERT into ResourceClassInts SET ".
                        "ResourceId = $ResourceId, ClassificationId ".
                        "= $ClassId";
                    $DB->Query($query);
                    
                    # update Classification resource count
                    $Class =& new Classification($ClassId);
                    $Class->RecalcResourceCount();
                }
                else
                {
                    $Session->PassVariable("ErrorMessage",
                        "Classification: $ClassName already ".
                        "associated with Resource Record<br>");
                }
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

if(substr($Submit, 0, 6) == "Assign")
    ProcessSelectedClassifications();
# else Cancel selected

# return to Entry screen    
PrintAutoRefreshPage("Add New Record", "SPT--DBEntry.php");
?>
