<?php
#
#   FILE:  SPT--EditControlledName.php
#
#   FUNCTIONS PROVIDED:
#       DisplayFoundControlledNames()
#           - displays results of search ControlledNames
#
#   FUNCTIONS EXPECTED:
#       DisplayControlledName()
#           - displays the ControlledNameId and ControlledName
#
#       DisplayControlledNamesForEdit()
#           - Displays Editable fields for a ControlledName
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Qualifier.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print the ControlledName
function PrintControlledName()
{
    global $F_ControlledName;

    print GetHtmlEscapedString($F_ControlledName);
}

# function to print the ControlledNameId
function PrintControlledNameId()
{
    global $F_ControlledNameId;

    print $F_ControlledNameId;
}

# function to print the ControlledNameId
function PrintVariantName()
{
    global $F_VariantName;

    print GetHtmlEscapedString($F_VariantName);
}

# return if ControlledNames exist or not
function ControlledNamesExist()
{
    global $NumRows;

    return $NumRows;
}

# print number of Rows
function PrintNumRows()
{
    global $NumRows;

    print $NumRows;
}

# function to see if Form variable F_ControlledName is empty or not
function SearchEntered()
{
    global $F_ControlledName;

    return (empty($F_ControlledName)) ? false : true;
}

#  display a ControlledName list of values as an option menu
function DisplayControlledNameList($Name = "F_ControlledNameTypeId",
            $Selected = "F_ControlledNameTypeId")
{
    global $F_ControlledNameTypeId;

    $DB =& new SPTDatabase();

    $Query = "Select * from ControlledNameTypes where ControlledNameIsList=0".
        " ORDER BY ControlledNameTypeName";
    $DB->Query($Query);

    while($Entry = $DB->FetchNextRowArray())
    {
        $Items[$Entry["ControlledNameTypeId"]] = 
            $Entry["ControlledNameTypeName"];
    }
    PrintOptionList($Name, $Items, $Selected, 0, 1, NULL, false);
}

# returns true if field uses qualifiers
function FieldUsesQualifiers()
{
    global $F_ControlledNameTypeId;
    
    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($F_ControlledNameTypeId);
    $Field = $Schema->GetFieldByName($Name);
    return $Field->UsesQualifiers();
}

# returns true if field uses item level qualifiers
function FieldHasItemLevelQualifiers()
{
    global $F_ControlledNameTypeId;

    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($F_ControlledNameTypeId);
    $Field = $Schema->GetFieldByName($Name);
    return $Field->HasItemLevelQualifiers();
}

# get default qualifier
function GetDefaultQualifier()
{
    global $F_ControlledNameTypeId;

    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($F_ControlledNameTypeId);
    $Field = $Schema->GetFieldByName($Name);
    $Qualifier = & new Qualifier($Field->DefaultQualifier());
    return $Qualifier->Name();
}

# function to print list of qualifiers
function PrintQualifierOrList()
{
    global $QualifierId;
    global $Index;
    global $F_ControlledNameTypeId;

    if(FieldHasItemLevelQualifiers())
    {
        $Schema = & new MetadataSchema();
        $Name = GetControlledNameType($F_ControlledNameTypeId);
        $Field = $Schema->GetFieldByName($Name);

        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_QualifierName_".$Index, $Items, $QualifierId,
            0, 1, NULL, false);
    }
    else
    {
        print GetDefaultQualifier();
    }
}

# display list of search results
function DisplayFoundControlledNames()
{
    global $DB;
    global $Index;
    global $F_ControlledNameId;
    global $F_ControlledName;
    global $F_VariantName;
    global $QualifierId;
    global $NumRows;

    $NumRows = $DB->NumRowsSelected();
    DisplayResults();
    
    $Index=0;
    while($Index < $DB->NumRowsSelected())
    {
        $DB1 =& new SPTDatabase();

        $Result = $DB->FetchNextRowArray();
        $F_ControlledNameId = $Result["ControlledNameId"];
        $F_ControlledName = $Result["ControlledName"];
        $F_ControlledNameTypeId = $Result["ControlledNameTypeId"];
        $F_VariantName = $Result["VariantName"];
        $QualifierId = $Result["QualifierId"];
              
        DisplayControlledNamesForEdit();
        DisplayControlledNameList("F_ControlledNameTypeId_".$Index, 
            $F_ControlledNameTypeId);
        # only display qualifer field if field uses qualifiers    
        if(FieldUsesQualifiers())
            DisplayQualifier();
        DisplayEndTags();    
        $Index++;
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# controlledname search
function ControlledNameSearch()
{
    global $Query, $HTTP_POST_VARS, $F_ControlledNameTypeId;

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];

    if(!empty($F_ControlledName))
    {
        # replace white space, parens, * and squigglies with wild cards
        # so that REGEXP in query doesn't puke
        $F_ControlledName = str_replace("*", ".*.", $F_ControlledName);
        $F_ControlledName = str_replace(" ", ".*.", $F_ControlledName);       
        $F_ControlledName = str_replace("{", ".*.", $F_ControlledName);       
        $F_ControlledName = str_replace("}", ".*.", $F_ControlledName);       
        $F_ControlledName = str_replace("(", ".*.", $F_ControlledName);       
        $F_ControlledName = str_replace(")", ".*.", $F_ControlledName); 

        # this Query gets us close
        $Query = "Select ControlledName, VariantName, C.ControlledNameId, ".
                "C.ControlledNameTypeId, QualifierId from ControlledNames AS C".
                " LEFT JOIN VariantNames ".
                "AS V ON C.ControlledNameId=V.ControlledNameId WHERE (".
                "ControlledName REGEXP \"$F_ControlledName\" OR ".
                "VariantName REGEXP \"$F_ControlledName\") ".
                "AND ControlledNameTypeId = ".$F_ControlledNameTypeId." ".
                "ORDER BY ControlledName";
    } 
    # nothing entered to search for
    else
    {
        $Query = "Select * from ControlledNames where ControlledName != ".
            "ControlledName";
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

$DB =& new SPTDatabase();

$F_ControlledNameTypeId = $HTTP_POST_VARS["F_ControlledNameTypeId"];

#controlled name search
ControlledNameSearch();

$DB->Query($Query);

$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");

?>
