<?php

#
#   FILE:  SPT--ExportData.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# open import file for reading

function GetFlaggedFilesCount()
{
    global $HTTP_SERVER_VARS, $NavDirCorrection;
    
    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/".$NavDirCorrection."TempStorage/InputData";

    if(is_readable($InputPath))
    {
        $fpi = fopen($InputPath, "r");
        while(!feof($fpi))
        {
            $ResourceId = fgets($fpi, 4096);
            $ResourceId = trim($ResourceId);

            if(empty($ResourceId))
                break;
        
            $ResourceCount++;
        }
    }
    return $ResourceCount;
}

function PrintFlaggedFilesMessage()
{
    $ResourceCount = GetFlaggedFilesCount();

    if($ResourceCount)
        print "$ResourceCount resources have been flagged for export.";
    else
    {
        print "No flagged files available for export.<br>";
        print "Use Advanced Search to flag files for export.<br>";
    }
}

require_once("include/SPT--Common.php");
PageTitle("Export Data");
$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

include("include/SPT--StandardHtmlPageLoad.php");


?>
