<?php
#
#   FILE:  SPT--MDHome.php
#
#   FUNCTIONS PROVIDED:
#       PrintTotalNumberOfResources()
#       PrintNumberOfReleasedResources()
#       PrintTotalNumberOfClassifications()
#       PrintTotalNumberOfControlledNames()
#           - print current values for each of the above
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001-2003 Internet Scout Project
#   http://scout.wisc.edu
#

$NavDirCorrection = "../";
require_once("include/SPT--Common.php");
PageTitle("Scout Portal Toolkit Metadata Tool");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTotalNumberOfResources()
{
    global $DB;

    # query total number of resources from DB
    $ResourceCount = $DB->Query("SELECT COUNT(*) AS ResourceCount "
            ."FROM Resources", "ResourceCount");

    # print result of query
    print(number_format($ResourceCount));
}

function PrintNumberOfReleasedResources()
{
    global $DB;

    # query number of released resources from DB
    $ResourceCount = $DB->Query("SELECT COUNT(*) AS ResourceCount "
            ."FROM Resources WHERE ReleaseFlag = 1", "ResourceCount");

    # print result of query
    print(number_format($ResourceCount));
}

function PrintNumberOfRatedResources()
{
    global $DB;

    # query number of released resources from DB
    $ResourceCount = $DB->Query("SELECT COUNT(DISTINCT ResourceId) AS ResourceCount "
            ."FROM ResourceRatings", "ResourceCount");

    # print result of query
    print(number_format($ResourceCount));
}

function PrintTotalNumberOfClassifications()
{
    global $DB;

    # query total number from DB
    $TotalCount = $DB->Query("SELECT COUNT(*) AS TotalCount "
            ."FROM Classifications", "TotalCount");

    # print result of query
    print(number_format($TotalCount));
}

function PrintTotalNumberOfControlledNames()
{
    global $DB;

    # query total number of non-list ControlledNames from DB
    $TotalCount = $DB->Query("SELECT COUNT(*) AS TotalCount "
            ."FROM ControlledNames, ControlledNameTypes WHERE "
            ."ControlledNames.ControlledNameTypeId = "
            ."ControlledNameTypes.ControlledNameTypeId AND "
            ."ControlledNameTypes.ControlledNameIsList = 0", "TotalCount");

    # print result of query
    print(number_format($TotalCount));
}

function PrintTotalSearchTerms()
{
    global $DB;

    # query total number from DB
    $TotalCount = $DB->Query("SELECT COUNT(*) AS TotalCount "
            ."FROM SearchWords", "TotalCount");

    # print result of query
    print(number_format($TotalCount));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_CLASSADMIN, PRIV_NAMEADMIN);

include("include/SPT--StandardHtmlPageLoad.php");


?>
