<?php
#
#   FILE:  SPT--SearchClassification.php
#
#   FUNCTIONS PROVIDED:
#       PrintResourceId()
#       - print out ResourceId
#
#       DisplayClassificationInfo()
#       - displays classification info from a query
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print out Resource Id
function ClassificationsExist()
{
    global $NumRows;

    return $NumRows;
}

# function to see if Form variable F_Class is empty or not
function SearchEntered()
{
    global $F_Class;

    return (empty($F_Class)) ? false : true;
}

# function to print ClassificationName
function PrintClassificationName()
{
    global $ClassificationName;

    print $ClassificationName;
}

# function to print ClassificationId
function PrintClassificationId()
{
    global $ClassificationId;

    print $ClassificationId;
}

# function to print ClassificationId
function PrintIndex()
{
    global $Index;

    print $Index;
}

# function to print ResourceCount 
function PrintResourceCount()
{
    global $ResourceCount;

    print $ResourceCount;
}

# display classification info
function DisplayClassificationInfo()
{
    global $F_Class;
    global $HTTP_POST_VARS;
    global $DB;
    global $User;
    global $ResourceId;
    global $NumRows;
    global $Index;
    global $ResourceCount;
    global $ClassificationName;
    global $ClassificationId;

    if(!empty($F_Class))
    {
        $F_Class = stripslashes($F_Class);
        trim($F_Class);
    
        # replace white space with wild cards 
        $F_Class = str_replace(" ", ".*.", $F_Class);       

        # this query gets us close
        $Query = "Select * from Classifications ".
                "WHERE (ClassificationName REGEXP \"$F_Class\") ".
                "ORDER BY ClassificationName";

        $DB->Query("$Query");
    
        $Index=0;

        $NumRows = $DB->NumRowsSelected();
     
        if($NumRows > 0)
        {
            DisplayHeading();
            while($Index < $DB->NumRowsSelected())
            {
      
                $Result = $DB->FetchNextRowArray();
                $ClassificationName = $Result["ClassificationName"];    
                $ClassificationId = $Result["ClassificationId"];
                $ResourceCount = $Result["ResourceCount"];
                DisplayClassificationSelection();
                $Index++;
            }
            DisplayAssignButtons();
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

# grab entry information from database
$DB =& new SPTDatabase();

# class is gotten from previous form
$F_Class = stripslashes($HTTP_POST_VARS["F_Class"]);
trim($F_Class);

PageTitle("Assign Classifications");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");


?>
