<?PHP

#
#   FILE:  SPT--EditSysConfigComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");


# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$ErrorMessages =& new ErrorList();

# if save changes was requested
if ($HTTP_POST_VARS["Submit"] != "Cancel")
{
    # if new administrator e-mail is valid
    $F_AdminEmail = trim($HTTP_POST_VARS["F_AdminEmail"]);
    if (preg_match("/[a-z0-9.\!%-_]+@[a-z0-9.-]+\.[a-z]+/i", $F_AdminEmail))
    {
        # save new administrator e-mail address
        $SysConfig->AdminEmail($F_AdminEmail);
    }
    else
    {
        # add error message to error list
        $ErrorMessages->AddMessage(
                "The administrator e-mail address you entered contained illegal characters or otherwise appeared to be invalid.");
        $Session->PassVariable("F_AdminEmail");
    }

    # save new portal name
    $SysConfig->PortalName($HTTP_POST_VARS["F_PortalName"]);

    # if new number of classifications per browse page is valid
    $F_NumClassesPerBrowsePage = 
        intval(trim($HTTP_POST_VARS["F_NumClassesPerBrowsePage"]));
    if (($F_NumClassesPerBrowsePage >= 4) && ($F_NumClassesPerBrowsePage <= 999))
    {
        # save new number of classifications per browse page
        $SysConfig->NumClassesPerBrowsePage($F_NumClassesPerBrowsePage);
    }
    else
    {
        # add error message to error list
        $ErrorMessages->AddMessage(
                "The number of classifications per page for browsing was invalid.  There must be at least 4 classifications per page.");
        $Session->PassVariable("F_NumClassesPerBrowsePage");
    }

    # if new number of announcements on home page is valid
    $F_NumAnnounceOnHomePage = 
        intval(trim($HTTP_POST_VARS["F_NumAnnounceOnHomePage"]));
    if (($F_NumAnnounceOnHomePage >= 1) && ($F_NumAnnounceOnHomePage <= 99))
    {
        # save new number of announcements on home page
        $SysConfig->NumAnnounceOnHomePage($F_NumAnnounceOnHomePage);
    }
    else
    {
        # add error message to error list
        $ErrorMessages->AddMessage(
                "The maximum number of announcements on the home page was invalid.  This value must be at least 1 and less than 100.");
        $Session->PassVariable("F_NumAnnounceOnHomePage");
    }

    # if new number of announcements on home page is valid
    $F_NumResourcesOnHomePage = 
        intval(trim($HTTP_POST_VARS["F_NumResourcesOnHomePage"]));
    if (($F_NumResourcesOnHomePage >= 1) && ($F_NumResourcesOnHomePage <= 99))
    {
        # save new number of announcements on home page
        $SysConfig->NumResourcesOnHomePage($F_NumResourcesOnHomePage);
    }
    else
    {
        # add error message to error list
        $ErrorMessages->AddMessage(
                "The maximum number of resources on the home page was invalid.  This value must be at least 1 and less than 100.");
        $Session->PassVariable("F_NumResourcesOnHomePage");
    }

    # save legal notice
    $SysConfig->LegalNotice($HTTP_POST_VARS["F_LegalNotice"]);
    
    # save new active user interface setting
    $SysConfig->DefaultActiveUI($HTTP_POST_VARS["F_DefaultActiveUI"]);

    # save new current user interface theme setting
    $SysConfig->CurrentTheme($HTTP_POST_VARS["F_CurrentTheme"]);

    # save new search term handling setting
    $SysConfig->SearchTermsRequired(($HTTP_POST_VARS["F_SearchTermHandling"] == "AND") ? 1 : 0);

    # save new announcements setting
    $SysConfig->AnnouncementsEnabled(($HTTP_POST_VARS["F_AnnouncementsEnabled"] == "1") ? 1 : 0);
    
    # save new forums setting
    $SysConfig->ForumsEnabled(($HTTP_POST_VARS["F_ForumsEnabled"] == "1") ? 1 : 0);

    # save new allow multiple UIs setting
    $SysConfig->AllowMultipleUIsEnabled(($HTTP_POST_VARS["F_AllowMultipleUIsEnabled"] == "1") ? 1 : 0);

    # save new resource launches new window setting
    $SysConfig->ResourceLaunchesNewWindowEnabled(($HTTP_POST_VARS["F_ResourceLaunchesNewWindowEnabled"] == "1") ? 1 : 0);

     # save new search user agents setting
    $SysConfig->UserAgentsEnabled(($HTTP_POST_VARS["F_UserAgentsEnabled"] == "1") ? 1 : 0);
    
    # save new resource ratings setting
    $SysConfig->ResourceRatingsEnabled(
                            ($HTTP_POST_VARS["F_ResourceRatingsEnabled"] == "1") ? 1 : 0);
    
    # save new resource ratings setting
    $SysConfig->ResourceCommentsEnabled(
                            ($HTTP_POST_VARS["F_ResourceCommentsEnabled"] == "1") ? 1 : 0);

    # save new search db setting
    $SysConfig->SearchDBEnabled(
                            ($HTTP_POST_VARS["F_SearchDBEnabled"] == "1") ? 1 : 0);
    
    # save new recommender db setting
    $SysConfig->RecommenderDBEnabled(
                            ($HTTP_POST_VARS["F_RecommenderDBEnabled"] == "1") ? 1 : 0);

    # save new about text 
    $SysConfig->AboutText($HTTP_POST_VARS["F_AboutText"]);

    # save new release flag setting 
    $SysConfig->ReleaseFlagApproved(($HTTP_POST_VARS["F_ReleaseFlagApproved"] == "1") ? 1 : 0);
}

# if errors were found
if (isset($ErrorMessages) && $ErrorMessages->HasErrors())
{
    # return to editing page with error messages
    $Session->PassVariable("ErrorMessages");
    PrintAutoRefreshPage("Errors Found", "SPT--EditSysConfig.php");
}
else
{
    # go to classification selection page for parent of edited classification
    PrintAutoRefreshPage("System Configuration Editing Complete", 
            "SPT--SysAdmin.php");
}

?>
