<?PHP

#
#   FILE:  SPT--LeaveFeedbackComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Feedback Recorded");

$F_Body = $HTTP_POST_VARS["F_Body"];
$F_Subject = $HTTP_POST_VARS["F_Subject"];

if ($HTTP_POST_VARS["Submit"] == "Send Feedback")
{
    # trim off any leading or trailing whitespace
    $F_Body = trim($F_Body);
    $F_Subject = trim($F_Subject);

    # feedback text was given
    if (strlen($F_Body) > 0)
    {
        # set subject to default if none supplied
        if (strlen($F_Subject) == 0) {  $F_Subject = "User Feedback";  }

        # prepend portal name onto subject
        $F_Subject = "[".$SysConfig->PortalName()."] ".$F_Subject;

        # prepend user info onto body
        if ($User->IsLoggedIn())
        {
            $F_Body = "[user feedback from ".$User->Get("UserName")
                    ." (".$User->Get("EMail").")"
                    ." connecting from ".$REMOTE_ADDR."]\n\n".$F_Body;
        }
        else
        {
            $F_Body = "[user feedback from an anonymous user"
                    ." connecting from ".$REMOTE_ADDR."]\n\n".$F_Body;
        }

        # assemble e-mail address for user
        if (strlen(trim($User->Get("RealName"))))
        {
            $UserEMail = trim($User->Get("RealName"))." <"
                    .$User->Get("EMail").">";
        }
        else
        {
            $UserEMail = trim($User->Get("UserName"))." <"
                    .$User->Get("EMail").">";
        }

        # mail feedback to admin
        $Result = mail($SysConfig->AdminEmail(), $F_Subject, $F_Body,
                "From: ${UserEMail}\r\n"
                        ."Reply-To: ${UserEMail}");
    }
}

include(FindUIFile("include/SPT--StandardPageStart.html"));
include(CorrespondingHtmlFile());
include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
